/*
 * Decompiled with CFR 0.152.
 */
package io.github.erdos.stencil.standalone;

import io.github.erdos.stencil.standalone.ArgsParser;
import java.io.File;
import java.nio.file.Files;
import java.util.Optional;

public final class StencilArgsParser {
    public static final ArgsParser PARSER = new ArgsParser();
    public static final ArgsParser.ParamMarker<File> OUTPUT_DIR = PARSER.addParam('o', "output", "Output directory path", string -> {
        File file = new File((String)string);
        if (!file.exists()) {
            throw new IllegalArgumentException("Output directory does not exist: " + file);
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("Output directory parameter is not a directory: " + file);
        }
        return file;
    });
    public static final ArgsParser.ParamMarker<Boolean> OVERWRITE = PARSER.addFlagOption('O', "overwrite", "Overwrite existing files");
    public static final ArgsParser.ParamMarker<Boolean> SHOW_HELP = PARSER.addFlagOption('h', "help", "Displays help screen");
    public static final ArgsParser.ParamMarker<Boolean> SHOW_VERSION = PARSER.addFlagOption('v', "version", "Displays version information");
    public static final ArgsParser.ParamMarker<Boolean> ONLY_INLCUDES = PARSER.addFlagOption('i', "only-include", "Only evaluate fragment includes");
    public static final ArgsParser.ParamMarker<File> JOBS_FILE = PARSER.addParam('j', "jobs", "File containing jobs", string -> {
        File file = new File((String)string);
        if (!file.exists()) {
            throw new IllegalArgumentException("Job file does not exist: " + file);
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException("Job file is not a file:" + file);
        }
        if (!Files.isReadable(file.toPath())) {
            throw new IllegalArgumentException("Job file is not readable: " + file);
        }
        return file;
    });
    public static final ArgsParser.ParamMarker<Boolean> JOBS_FROM_STDIN = PARSER.addFlagOption('s', "stdin", "Jobs come from the standard input");

    private StencilArgsParser() {
    }

    public static ArgsParser.ParseResult parse(String ... stringArray) {
        return PARSER.parse(stringArray);
    }

    public static File getOutputDirectory(ArgsParser.ParseResult parseResult) {
        Optional<File> optional = parseResult.getParamValue(OUTPUT_DIR);
        File file = optional.orElse(new File(".").getAbsoluteFile());
        if (!file.exists()) {
            throw new IllegalArgumentException("Output directory does not exist: " + file);
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("Output path is not a directory: " + file);
        }
        return file;
    }

    public static Boolean getOutputOverwritten(ArgsParser.ParseResult parseResult) {
        return parseResult.getParamValue(OVERWRITE).orElse(false);
    }

    public static Boolean getOnlyIncludes(ArgsParser.ParseResult parseResult) {
        return parseResult.getParamValue(ONLY_INLCUDES).orElse(false);
    }
}

