/*
 * Decompiled with CFR 0.152.
 */
package io.github.erdos.stencil.standalone;

import io.github.erdos.stencil.impl.FileHelper;
import io.github.erdos.stencil.standalone.EdnParser;
import io.github.erdos.stencil.standalone.JsonParser;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Optional;

public class Parser {
    public static Optional<DataFileFormat> maybeDataFileFormat(File file) {
        String string = FileHelper.extension(file);
        if ("json".equals(string)) {
            return Optional.of(DataFileFormat.JSON);
        }
        if ("edn".equals(string)) {
            return Optional.of(DataFileFormat.EDN);
        }
        return Optional.empty();
    }

    private static String fileContents(File file) throws IOException {
        return new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
    }

    public static enum DataFileFormat {
        JSON{

            @Override
            public Object parse(File file) throws IOException {
                return JsonParser.parse(Parser.fileContents(file));
            }
        }
        ,
        EDN{

            @Override
            public Object parse(File file) throws IOException {
                return EdnParser.parse(Parser.fileContents(file)).get();
            }
        };


        public abstract Object parse(File var1) throws IOException;
    }
}

