/*
 * Decompiled with CFR 0.152.
 */
package io.github.erdos.stencil.standalone;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public final class JsonParser {
    public static Object parse(String string) throws IOException {
        return JsonParser.read(new StringReader(string));
    }

    public static Object read(Reader reader) throws IOException {
        return JsonParser.simpleParse(new PushbackReader(reader, 128));
    }

    private static char peekNextNonWs(PushbackReader pushbackReader) throws IOException {
        char[] cArray = new char[1];
        do {
            int n;
            if ((n = pushbackReader.read(cArray, 0, 1)) != -1) continue;
            throw new IllegalStateException("Unexpected end of input!");
        } while (Character.isWhitespace(cArray[0]));
        pushbackReader.unread(cArray[0]);
        return cArray[0];
    }

    private static Object simpleParse(PushbackReader pushbackReader) throws IOException {
        char c = JsonParser.peekNextNonWs(pushbackReader);
        if (c == '{') {
            return JsonParser.readMap(pushbackReader);
        }
        if (c == '[') {
            return JsonParser.readVec(pushbackReader);
        }
        if (c == '\"') {
            return JsonParser.readStr(pushbackReader);
        }
        if (c == 't') {
            JsonParser.expectWord("true", pushbackReader);
            return Boolean.TRUE;
        }
        if (c == 'f') {
            JsonParser.expectWord("false", pushbackReader);
            return Boolean.FALSE;
        }
        if (c == 'n') {
            JsonParser.expectWord("null", pushbackReader);
            return null;
        }
        if (Character.isDigit(c) || c == '+' || c == '-') {
            return JsonParser.readNumber(pushbackReader);
        }
        throw new IllegalStateException("Unexpected character: '" + c + "'");
    }

    static Number readNumber(PushbackReader pushbackReader) throws IOException {
        int n;
        char[] cArray = new char[128];
        int n2 = pushbackReader.read(cArray, 0, cArray.length);
        assert (cArray[0] == '+' || cArray[0] == '-' || Character.isDigit(cArray[0]));
        for (n = 0; n < n2 && (cArray[n] == '.' || cArray[n] == '-' || cArray[n] == 'e' || Character.isDigit(cArray[n])); ++n) {
        }
        if (n < n2) {
            pushbackReader.unread(cArray, n, n2 - n);
        }
        try {
            return new BigDecimal(cArray, 0, n);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalStateException("Could not parse '" + new String(cArray, 0, n) + "'", numberFormatException);
        }
    }

    static String readStr(PushbackReader pushbackReader) throws IOException {
        JsonParser.expectWord("\"", pushbackReader);
        StringBuilder stringBuilder = new StringBuilder();
        while (true) {
            int n;
            if ((n = pushbackReader.read()) == -1) {
                throw new IllegalStateException("Unexpected end of file!");
            }
            if (n == 92) {
                int n2 = pushbackReader.read();
                if (n2 == 92 || n2 == 34) {
                    stringBuilder.append((char)n2);
                    continue;
                }
                if (n2 == 110) {
                    stringBuilder.append('\n');
                    continue;
                }
                if (n2 == 116) {
                    stringBuilder.append('\t');
                    continue;
                }
                if (n2 == 114) {
                    stringBuilder.append('\r');
                    continue;
                }
                throw new IllegalStateException("Unexpected character: \\" + (char)n2);
            }
            if (n == 34) {
                return stringBuilder.toString();
            }
            stringBuilder.append((char)n);
        }
    }

    static void expectWord(String string, PushbackReader pushbackReader) throws IOException {
        char[] cArray = new char[string.length()];
        if (pushbackReader.read(cArray, 0, cArray.length) != cArray.length || !Arrays.equals(cArray, string.toCharArray())) {
            throw new IllegalStateException("Expected: " + string + " but found " + new String(cArray) + " instead.");
        }
    }

    static List<Object> readVec(PushbackReader pushbackReader) throws IOException {
        JsonParser.expectWord("[", pushbackReader);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (true) {
            char c;
            if ((c = JsonParser.peekNextNonWs(pushbackReader)) == ']') {
                pushbackReader.read();
                return Collections.unmodifiableList(arrayList);
            }
            if (c == ',') {
                pushbackReader.read();
                continue;
            }
            Object object = JsonParser.simpleParse(pushbackReader);
            arrayList.add(object);
        }
    }

    static Object readMap(PushbackReader pushbackReader) throws IOException {
        char c;
        JsonParser.expectWord("{", pushbackReader);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        while (true) {
            char c2;
            if ((c2 = JsonParser.peekNextNonWs(pushbackReader)) == '}') {
                pushbackReader.read();
                return Collections.unmodifiableMap(hashMap);
            }
            String string = JsonParser.readStr(pushbackReader);
            char c3 = JsonParser.peekNextNonWs(pushbackReader);
            if (c3 != ':') {
                throw new IllegalStateException("Unexpected character " + c3 + ", expected ':'");
            }
            pushbackReader.read();
            Object object = JsonParser.simpleParse(pushbackReader);
            hashMap.put(string, object);
            c = JsonParser.peekNextNonWs(pushbackReader);
            if (c == '}') continue;
            if (c != ',') break;
            pushbackReader.read();
        }
        throw new IllegalStateException("Unexpected character after key-value pair in JSON: '" + c + "'");
    }
}

