/*
 * Decompiled with CFR 0.152.
 */
package io.github.erdos.stencil.functions;

import io.github.erdos.stencil.functions.Function;
import io.github.erdos.stencil.functions.FunctionsProvider;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;

public enum DateFunctions implements Function
{
    DATE{

        @Override
        public Object call(Object ... objectArray) throws IllegalArgumentException {
            Object object;
            String string;
            Locale locale;
            if (objectArray.length != 2 && objectArray.length != 3) {
                throw new IllegalArgumentException("date() function expects exactly 2 or 3 arguments!");
            }
            if (objectArray[0] == null || objectArray[1] == null || objectArray[1].toString().isEmpty()) {
                return null;
            }
            if (objectArray.length == 2) {
                locale = Locale.getDefault();
                string = objectArray[0].toString();
                object = objectArray[1];
            } else {
                if (objectArray[2] == null || objectArray[2].toString().isEmpty()) {
                    return null;
                }
                locale = Locale.forLanguageTag(objectArray[0].toString());
                string = objectArray[1].toString();
                object = objectArray[2];
            }
            Optional optional = DateFunctions.maybeLocalDate(object);
            if (optional.isPresent()) {
                return ((LocalDate)optional.get()).format(DateTimeFormatter.ofPattern(string, locale));
            }
            Optional optional2 = DateFunctions.maybeLocalDateTime(object);
            if (optional2.isPresent()) {
                return ((LocalDateTime)optional2.get()).format(DateTimeFormatter.ofPattern(string, locale));
            }
            Optional optional3 = DateFunctions.maybeDate(object);
            if (optional3.isPresent()) {
                return new SimpleDateFormat(string, locale).format((Date)optional3.get());
            }
            throw new IllegalArgumentException("Could not parse date object " + object.toString());
        }
    };

    public static final String DATETIME1 = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_TOSTRING = "EEE MMM dd HH:mm:ss Z yyyy";
    public static final String DATE_DOTTED = "yyyy. MM. dd.";
    public static final String RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final String RFC1036 = "EEEE, dd-MMM-yy HH:mm:ss zzz";
    public static final String ASCTIME = "EEE MMM d HH:mm:ss yyyy";
    public static final String ISO8601 = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";
    public static final List<String> PATTERNS;

    private static Optional<Date> maybeDate(Object object) {
        if (object instanceof Date) {
            return Optional.of((Date)object);
        }
        String string = object.toString();
        try {
            return Optional.of(DatatypeFactory.newInstance().newXMLGregorianCalendar(string).toGregorianCalendar().getTime());
        }
        catch (IllegalArgumentException | DatatypeConfigurationException exception) {
            for (String string2 : PATTERNS) {
                try {
                    return Optional.of(new SimpleDateFormat(string2).parse(string));
                }
                catch (ParseException parseException) {
                }
            }
            return Optional.empty();
        }
    }

    private static Optional<LocalDate> maybeLocalDate(Object object) {
        if (object instanceof LocalDate) {
            return Optional.of((LocalDate)object);
        }
        try {
            return Optional.of(LocalDate.parse(object.toString()));
        }
        catch (DateTimeParseException dateTimeParseException) {
            return Optional.empty();
        }
    }

    private static Optional<LocalDateTime> maybeLocalDateTime(Object object) {
        if (object instanceof LocalDateTime) {
            return Optional.of((LocalDateTime)object);
        }
        try {
            return Optional.of(LocalDateTime.parse(object.toString()));
        }
        catch (DateTimeParseException dateTimeParseException) {
            return Optional.empty();
        }
    }

    @Override
    public String getName() {
        return this.name().toLowerCase();
    }

    static {
        PATTERNS = Arrays.asList(DATETIME1, RFC1036, RFC1123, ASCTIME, ISO8601, DATE_TOSTRING, DATE_DOTTED);
    }

    public static class Provider
    implements FunctionsProvider {
        @Override
        public Iterable<Function> functions() {
            return Arrays.asList(DateFunctions.values());
        }
    }
}

