/*
 * Decompiled with CFR 0.152.
 */
package io.github.erdos.stencil.impl;

import io.github.erdos.stencil.PrepareOptions;
import io.github.erdos.stencil.PreparedTemplate;
import io.github.erdos.stencil.TemplateFactory;
import java.io.File;
import java.io.IOException;
import java.time.ZoneOffset;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class CachingTemplateFactory
implements TemplateFactory {
    private final TemplateFactory templateFactory;
    private final Map<File, PreparedTemplate> cache = new ConcurrentHashMap<File, PreparedTemplate>();

    public CachingTemplateFactory(TemplateFactory templateFactory) {
        if (templateFactory == null) {
            throw new IllegalArgumentException("can not wrap null object!");
        }
        this.templateFactory = templateFactory;
    }

    @Override
    public PreparedTemplate prepareTemplateFile(File file, PrepareOptions prepareOptions) throws IOException {
        if (this.cache.containsKey(file)) {
            PreparedTemplate preparedTemplate = this.cache.get(file);
            if (preparedTemplate.creationDateTime().toEpochSecond(ZoneOffset.UTC) <= file.lastModified()) {
                preparedTemplate.close();
                preparedTemplate = this.templateFactory.prepareTemplateFile(file, prepareOptions);
                this.cache.put(file, preparedTemplate);
            }
            return preparedTemplate;
        }
        PreparedTemplate preparedTemplate = this.templateFactory.prepareTemplateFile(file, PrepareOptions.options());
        this.cache.put(file, preparedTemplate);
        return preparedTemplate;
    }
}

