/*
 * Decompiled with CFR 0.152.
 */
package gradle_clojure.plugin;

import gradle_clojure.plugin.ClojureBasePlugin;
import gradle_clojure.plugin.tasks.ClojureCompile;
import gradle_clojure.plugin.tasks.ClojureNRepl;
import gradle_clojure.plugin.tasks.ClojureSourceSet;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;

public class ClojurePlugin
implements Plugin<Project> {
    private static final String DEV_SOURCE_SET_NAME = "dev";

    public void apply(Project project) {
        project.getPlugins().apply(ClojureBasePlugin.class);
        project.getPlugins().apply(JavaPlugin.class);
        JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
        this.configureTest(project, javaConvention);
        this.configureDev(project, javaConvention);
    }

    private void configureTest(Project project, JavaPluginConvention javaConvention) {
        SourceSet sourceSet = (SourceSet)javaConvention.getSourceSets().getByName("test");
        ClojureCompile compile = (ClojureCompile)project.getTasks().getByName(sourceSet.getCompileTaskName("clojure"));
        compile.getOptions().setAotCompile(true);
        Callable<Object> namespaces = () -> {
            ArrayList<String> nses = new ArrayList<String>();
            nses.add("gradle-clojure.tools.logger");
            nses.add("gradle-clojure.tools.clojure-test-junit4");
            nses.addAll(compile.findNamespaces());
            return nses;
        };
        compile.getConventionMapping().map("namespaces", namespaces);
    }

    private void configureDev(Project project, JavaPluginConvention javaConvention) {
        SourceSet main = (SourceSet)javaConvention.getSourceSets().getByName("main");
        SourceSet test = (SourceSet)javaConvention.getSourceSets().getByName("test");
        SourceSet dev = (SourceSet)javaConvention.getSourceSets().create(DEV_SOURCE_SET_NAME);
        SourceDirectorySet mainClojure = ((ClojureSourceSet)new DslObject((Object)main).getConvention().getPlugin(ClojureSourceSet.class)).getClojure();
        SourceDirectorySet testClojure = ((ClojureSourceSet)new DslObject((Object)test).getConvention().getPlugin(ClojureSourceSet.class)).getClojure();
        SourceDirectorySet devClojure = ((ClojureSourceSet)new DslObject((Object)dev).getConvention().getPlugin(ClojureSourceSet.class)).getClojure();
        dev.setCompileClasspath((FileCollection)project.files(new Object[]{test.getOutput(), main.getOutput(), project.getConfigurations().getByName(dev.getCompileClasspathConfigurationName())}));
        dev.setRuntimeClasspath((FileCollection)project.files(new Object[]{devClojure.getSourceDirectories(), dev.getOutput().minus((FileCollection)project.files(new Object[]{devClojure.getOutputDir()})), testClojure.getSourceDirectories(), test.getOutput().minus((FileCollection)project.files(new Object[]{testClojure.getOutputDir()})), mainClojure.getSourceDirectories(), main.getOutput().minus((FileCollection)project.files(new Object[]{mainClojure.getOutputDir()})), project.getConfigurations().getByName(dev.getRuntimeClasspathConfigurationName())}));
        Stream.of(SourceSet::getCompileConfigurationName, SourceSet::getImplementationConfigurationName, SourceSet::getRuntimeConfigurationName, SourceSet::getRuntimeOnlyConfigurationName).forEach(getter -> {
            Configuration devConf = project.getConfigurations().getByName((String)getter.apply(dev));
            Configuration testConf = project.getConfigurations().getByName((String)getter.apply(test));
            devConf.extendsFrom(new Configuration[]{testConf});
        });
        project.getTasks().create("clojureRepl", ClojureNRepl.class, task -> {
            task.setGroup("run");
            task.setDescription("Starts an nREPL server.");
            task.setClasspath(dev.getRuntimeClasspath());
        });
    }
}

