/*
 * Decompiled with CFR 0.152.
 */
package gradle_clojure.plugin.internal;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Set;

public class WhitelistClassLoader
extends URLClassLoader {
    private final Set<String> prefixes;

    public WhitelistClassLoader(Set<String> prefixes, ClassLoader parent) {
        super(new URL[0], parent);
        this.prefixes = prefixes;
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (this.allowedClass(name)) {
            return super.loadClass(name, resolve);
        }
        throw new ClassNotFoundException("Class is not in the whitelist: " + name);
    }

    @Override
    public URL getResource(String name) {
        if (this.allowedClass(name)) {
            return super.getResource(name);
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (this.allowedClass(name)) {
            return super.getResources(name);
        }
        return new EmptyEnumeration<URL>();
    }

    private boolean allowedClass(String name) {
        return this.prefixes.stream().anyMatch(name::startsWith);
    }

    private static class EmptyEnumeration<T>
    implements Enumeration<T> {
        private EmptyEnumeration() {
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public T nextElement() {
            throw new NoSuchElementException();
        }
    }
}

