/*
 * Decompiled with CFR 0.152.
 */
package gradle_clojure.plugin.internal;

import gradle_clojure.plugin.internal.WhitelistClassLoader;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.projectodd.shimdandy.ClojureRuntimeShim;

public class ClojureWorker
implements Runnable {
    private static final Set<String> CLASSLOADER_WHITELIST = Stream.of("org.projectodd.shimdandy.", "java.", "javax.", "jdk.", "sun.", "com.sun.", "org.ietf.", "org.omg.", "org.w3c.", "org.xml.").collect(Collectors.toSet());
    private static final UUID workerId = UUID.randomUUID();
    private static final AtomicInteger workerUseCounter = new AtomicInteger(0);
    private final String namespace;
    private final Object[] args;
    private final Set<File> classpath;

    @Inject
    public ClojureWorker(String namespace, Object[] args, Set<File> classpath) {
        this.namespace = namespace;
        this.args = args;
        this.classpath = classpath;
    }

    @Override
    public void run() {
        String logLevel = System.getProperty("gradle-clojure.tools.logger.level");
        if ("debug".equals(logLevel) || "info".equals(logLevel)) {
            System.out.println(String.format("INFO Worker process  %s has been used %d times.", workerId, workerUseCounter.incrementAndGet()));
        }
        try (ClojureRuntime runtime = ClojureRuntime.get(this.classpath);){
            ClojureRuntimeShim shim = runtime.getShim();
            shim.require(new String[]{this.namespace});
            Object sym = shim.invoke("clojure.core/symbol", (Object)this.namespace, (Object)"-main");
            Object var = shim.invoke("clojure.core/find-var", sym);
            shim.invoke("clojure.core/apply", var, (Object)this.args);
        }
    }

    private static class ClojureRuntime
    implements AutoCloseable {
        private final URLClassLoader loader;
        private final ClojureRuntimeShim shim;

        private ClojureRuntime(URLClassLoader loader, ClojureRuntimeShim shim) {
            this.loader = loader;
            this.shim = shim;
        }

        public ClojureRuntimeShim getShim() {
            return this.shim;
        }

        @Override
        public void close() {
            try {
                this.shim.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.loader.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public static ClojureRuntime get(Set<File> classpath) {
            URL[] classpathUrls = (URL[])classpath.stream().map(File::toURI).map(ClojureRuntime.safe(URI::toURL)).toArray(URL[]::new);
            WhitelistClassLoader parent = new WhitelistClassLoader(CLASSLOADER_WHITELIST, ClojureWorker.class.getClassLoader());
            URLClassLoader loader = new URLClassLoader(classpathUrls, (ClassLoader)parent);
            ClojureRuntimeShim shim = ClojureRuntimeShim.newRuntime((ClassLoader)loader, (String)"gradle-clojure");
            return new ClojureRuntime(loader, shim);
        }

        private static <T, R> Function<T, R> safe(FunctionThrows<T, R> fun) {
            return fun;
        }

        private static <T extends Throwable> void sneakyThrows(Throwable t) throws T {
            throw t;
        }

        private static interface FunctionThrows<T, R>
        extends Function<T, R> {
            @Override
            default public R apply(T arg) {
                try {
                    return this.applyThrows(arg);
                }
                catch (Exception e) {
                    ClojureRuntime.sneakyThrows(e);
                    return null;
                }
            }

            public R applyThrows(T var1) throws Exception;
        }
    }
}

