/*
 * Decompiled with CFR 0.152.
 */
package gradle_clojure.plugin.common.internal;

import gradle_clojure.plugin.common.internal.ClojureExecSpec;
import gradle_clojure.plugin.common.internal.Edn;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;

public final class ClojureExecutor {
    private static final String GRADLE_CLOJURE_VERSION = ClojureExecutor.getVersion();
    private final Project project;

    public ClojureExecutor(Project project) {
        this.project = project;
    }

    public void exec(Action<ClojureExecSpec> action) {
        ClojureExecSpec cljSpec = new ClojureExecSpec();
        action.execute((Object)cljSpec);
        this.exec(cljSpec);
    }

    public void exec(ClojureExecSpec cljSpec) {
        FileCollection fullClasspath = cljSpec.getClasspath().plus(this.resolve(this.tools()));
        this.project.javaexec(spec -> {
            spec.setMain("clojure.main");
            spec.args(new Object[]{"-m", cljSpec.getMain()});
            String ednArgs = Edn.print(Arrays.asList(cljSpec.getArgs()));
            ByteArrayInputStream input = new ByteArrayInputStream(ednArgs.getBytes(StandardCharsets.UTF_8));
            spec.setStandardInput((InputStream)input);
            spec.setClasspath(fullClasspath);
            cljSpec.getConfigureFork().forEach(forkAction -> forkAction.execute(spec));
            spec.systemProperty("gradle-clojure.tools.logger.level", (Object)this.getLogLevel());
        });
    }

    public FileCollection resolve(Dependency ... deps) {
        return this.project.getConfigurations().detachedConfiguration(deps).setTransitive(false);
    }

    public Dependency tools() {
        return this.project.getDependencies().create((Object)("io.github.gradle-clojure:gradle-clojure-tools:" + GRADLE_CLOJURE_VERSION));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getVersion() {
        try (InputStream stream = ClojureExecutor.class.getResourceAsStream("/gradle-clojure.properties");){
            Properties props = new Properties();
            props.load(stream);
            String string = props.getProperty("version");
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private String getLogLevel() {
        Supplier<String> gradleLevel = () -> Stream.of(LogLevel.DEBUG, LogLevel.INFO, LogLevel.LIFECYCLE, LogLevel.WARN, LogLevel.QUIET, LogLevel.ERROR).filter(arg_0 -> ((Logger)this.project.getLogger()).isEnabled(arg_0)).map(Enum::toString).map(String::toLowerCase).findFirst().orElse("info");
        return Optional.ofNullable(this.project.findProperty("gradle-clojure.tools.logger.level")).map(Object::toString).orElseGet(gradleLevel);
    }
}

