/*
 * Decompiled with CFR 0.152.
 */
package gradle_clojure.plugin.common.internal;

import gradle_clojure.plugin.clojure.tasks.ClojureCompileOptions;
import gradle_clojure.plugin.clojure.tasks.ReflectionWarnings;
import gradle_clojure.plugin.clojurescript.tasks.ClojureScriptCompileOptions;
import gradle_clojure.plugin.clojurescript.tasks.ForeignLib;
import gradle_clojure.plugin.clojurescript.tasks.Module;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import us.bpsm.edn.Keyword;
import us.bpsm.edn.Symbol;
import us.bpsm.edn.parser.Parseable;
import us.bpsm.edn.parser.Parser;
import us.bpsm.edn.parser.Parsers;
import us.bpsm.edn.printer.Printer;
import us.bpsm.edn.printer.Printers;
import us.bpsm.edn.protocols.Protocol;

public class Edn {
    private static final Printer.Fn<Enum<?>> ENUM_PRINTER = (self, printer) -> printer.printValue((Object)Keyword.newKeyword((String)self.name()));
    private static final Printer.Fn<File> FILE_PRINTER = (self, printer) -> printer.printValue((Object)self.getAbsolutePath());
    private static final Printer.Fn<ClojureCompileOptions> CLOJURE_COMPILE_OPTIONS_PRINTER = (self, printer) -> {
        LinkedHashMap<Keyword, Object> compiler = new LinkedHashMap<Keyword, Object>();
        compiler.put(Keyword.newKeyword((String)"disable-locals-clearing"), self.isDisableLocalsClearing());
        compiler.put(Keyword.newKeyword((String)"direct-linking"), self.isDirectLinking());
        compiler.put(Keyword.newKeyword((String)"elide-metadata"), self.getElideMeta().stream().map(Keyword::newKeyword).collect(Collectors.toList()));
        LinkedHashMap<Keyword, Object> root = new LinkedHashMap<Keyword, Object>();
        root.put(Keyword.newKeyword((String)"reflection-warnings"), self.getReflectionWarnings());
        root.put(Keyword.newKeyword((String)"compiler-options"), compiler);
        printer.printValue(root);
    };
    private static final Printer.Fn<ReflectionWarnings> REFLECTION_WARNINGS_PRINTER = (self, printer) -> {
        LinkedHashMap<Keyword, Boolean> root = new LinkedHashMap<Keyword, Boolean>();
        root.put(Keyword.newKeyword((String)"enabled"), self.isEnabled());
        root.put(Keyword.newKeyword((String)"as-errors"), self.isAsErrors());
        root.put(Keyword.newKeyword((String)"project-only"), self.isProjectOnly());
        printer.printValue(root);
    };
    private static final Printer.Fn<ClojureScriptCompileOptions> CLOJURESCRIPT_COMPILE_OPTIONS_PRINTER = (self, printer) -> {
        LinkedHashMap<Keyword, Object> map = new LinkedHashMap<Keyword, Object>();
        map.put(Keyword.newKeyword((String)"output-to"), self.getOutputTo().getAsFile().getOrNull());
        map.put(Keyword.newKeyword((String)"output-dir"), self.getOutputDir().getAsFile().getOrNull());
        map.put(Keyword.newKeyword((String)"optimizations"), (Object)self.getOptimizations());
        map.put(Keyword.newKeyword((String)"main"), self.getMain());
        map.put(Keyword.newKeyword((String)"asset-path"), self.getAssetPath());
        map.put(Keyword.newKeyword((String)"source-map"), self.getSourceMap());
        map.put(Keyword.newKeyword((String)"verbose"), self.getVerbose());
        map.put(Keyword.newKeyword((String)"pretty-print"), self.getPrettyPrint());
        map.put(Keyword.newKeyword((String)"target"), (Object)self.getTarget());
        map.put(Keyword.newKeyword((String)"foreign-libs"), Edn.emptyToNull(self.getForeignLibs()));
        map.put(Keyword.newKeyword((String)"externs"), Edn.emptyToNull(self.getExterns()));
        map.put(Keyword.newKeyword((String)"modules"), Edn.parseModules(self.getModules()));
        map.put(Keyword.newKeyword((String)"preloads"), Edn.parsePreloads(self.getPreloads()));
        map.put(Keyword.newKeyword((String)"npm-deps"), Edn.emptyToNull(self.getNpmDeps()));
        map.put(Keyword.newKeyword((String)"install-deps"), self.getInstallDeps());
        map.put(Keyword.newKeyword((String)"checked-arrays"), (Object)self.getCheckedArrays());
        map.values().removeIf(Objects::isNull);
        printer.printValue(map);
    };
    private static final Printer.Fn<ForeignLib> FOREIGN_LIB_PRINTER = (self, printer) -> {
        LinkedHashMap<Keyword, Object> map = new LinkedHashMap<Keyword, Object>();
        map.put(Keyword.newKeyword((String)"file"), self.getFile());
        map.put(Keyword.newKeyword((String)"file-min"), self.getFileMin());
        map.put(Keyword.newKeyword((String)"provides"), self.getProvides());
        map.put(Keyword.newKeyword((String)"requires"), self.getRequires());
        map.put(Keyword.newKeyword((String)"module-type"), (Object)self.getModuleType());
        map.put(Keyword.newKeyword((String)"preprocess"), Edn.parsePreprocess(self.getPreprocess()));
        map.put(Keyword.newKeyword((String)"global-exports"), Edn.parseGlobalExports(self.getGlobalExports()));
        map.values().removeIf(Objects::isNull);
        printer.printValue(map);
    };
    private static final Printer.Fn<Module> MODULE_PRINTER = (module, printer) -> {
        LinkedHashMap<Keyword, Object> map = new LinkedHashMap<Keyword, Object>();
        map.put(Keyword.newKeyword((String)"output-to"), module.getOutputTo().getAsFile().getOrNull());
        map.put(Keyword.newKeyword((String)"entries"), module.getEntries());
        map.put(Keyword.newKeyword((String)"dependsOn"), module.getDependsOn());
        map.values().removeIf(Objects::isNull);
        printer.printValue(map);
    };
    private static final Protocol<Printer.Fn<?>> PROTOCOL = Printers.prettyProtocolBuilder().put(Enum.class, ENUM_PRINTER).put(File.class, FILE_PRINTER).put(ClojureCompileOptions.class, CLOJURE_COMPILE_OPTIONS_PRINTER).put(ReflectionWarnings.class, REFLECTION_WARNINGS_PRINTER).put(ClojureScriptCompileOptions.class, CLOJURESCRIPT_COMPILE_OPTIONS_PRINTER).put(ForeignLib.class, FOREIGN_LIB_PRINTER).put(Module.class, MODULE_PRINTER).build();

    private static Map<Keyword, Module> parseModules(Map<String, Module> modules) {
        Map<Keyword, Module> result = modules.entrySet().stream().collect(Collectors.toMap(e -> Keyword.newKeyword((String)((String)e.getKey())), Map.Entry::getValue));
        return Edn.emptyToNull(result);
    }

    private static List<Symbol> parsePreloads(Collection<String> preloads) {
        if (preloads == null) {
            return null;
        }
        return preloads.stream().map(Symbol::newSymbol).collect(Collectors.toList());
    }

    private static Object parsePreprocess(String value) {
        if (value == null) {
            return null;
        }
        Parseable parseable = Parsers.newParseable((CharSequence)value);
        Parser parser = Parsers.newParser((Parser.Config)Parsers.defaultConfiguration());
        return parser.nextValue(parseable);
    }

    private static Map<Symbol, Symbol> parseGlobalExports(Map<String, String> globalExports) {
        return globalExports.entrySet().stream().collect(Collectors.toMap(e -> Symbol.newSymbol((String)((String)e.getKey())), e -> Symbol.newSymbol((String)((String)e.getValue()))));
    }

    public static String print(Object value) {
        return Printers.printString(PROTOCOL, (Object)value);
    }

    private static <T extends Collection<?>> T emptyToNull(T collection) {
        return (T)((Collection)Optional.ofNullable(collection).filter(c -> !c.isEmpty()).orElse(null));
    }

    private static <T extends Map<?, ?>> T emptyToNull(T collection) {
        return (T)((Map)Optional.ofNullable(collection).filter(c -> !c.isEmpty()).orElse(null));
    }
}

