/*
 * Decompiled with CFR 0.152.
 */
package gradle_clojure.plugin.clojure;

import gradle_clojure.plugin.clojure.internal.DefaultClojureSourceSet;
import gradle_clojure.plugin.clojure.tasks.ClojureCheck;
import gradle_clojure.plugin.clojure.tasks.ClojureCompile;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Properties;
import javax.inject.Inject;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ComponentModuleMetadataDetails;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.SourceDirectorySetFactory;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.provider.Provider;

public class ClojureBasePlugin
implements Plugin<Project> {
    public static final String TOOLS_CONFIGURATION_NAME = "clojureTools";
    public static final String NREPL_CONFIGURATION_NAME = "nrepl";
    private final SourceDirectorySetFactory sourceDirectorySetFactory;

    @Inject
    public ClojureBasePlugin(SourceDirectorySetFactory sourceDirectorySetFactory) {
        this.sourceDirectorySetFactory = sourceDirectorySetFactory;
    }

    public void apply(Project project) {
        project.getPluginManager().apply(JavaBasePlugin.class);
        this.configureSourceSetDefaults(project);
        this.configureModuleReplacements(project);
    }

    private void configureSourceSetDefaults(Project project) {
        Configuration tools = (Configuration)project.getConfigurations().create(TOOLS_CONFIGURATION_NAME);
        tools.defaultDependencies(deps -> deps.add((Object)project.getDependencies().create((Object)("io.github.gradle-clojure:gradle-clojure-tools:" + this.getVersion()))));
        Configuration nrepl = (Configuration)project.getConfigurations().create(NREPL_CONFIGURATION_NAME);
        nrepl.defaultDependencies(deps -> deps.add((Object)project.getDependencies().create((Object)"nrepl:nrepl:0.3.1")));
        ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().all(sourceSet -> {
            DefaultClojureSourceSet clojureSourceSet = new DefaultClojureSourceSet("clojure", this.sourceDirectorySetFactory);
            new DslObject(sourceSet).getConvention().getPlugins().put("clojure", clojureSourceSet);
            project.getConfigurations().getByName(sourceSet.getCompileClasspathConfigurationName()).extendsFrom(new Configuration[]{tools});
            project.getConfigurations().getByName(sourceSet.getRuntimeClasspathConfigurationName()).extendsFrom(new Configuration[]{tools});
            clojureSourceSet.getClojure().srcDir((Object)String.format("src/%s/clojure", sourceSet.getName()));
            sourceSet.getResources().getFilter().exclude(element -> clojureSourceSet.getClojure().contains(element.getFile()));
            sourceSet.getAllSource().source(clojureSourceSet.getClojure());
            Provider classpath = project.provider(() -> sourceSet.getCompileClasspath().plus((FileCollection)project.files(new Object[]{sourceSet.getJava().getOutputDir()})).plus((FileCollection)project.files(new Object[]{sourceSet.getOutput().getResourcesDir()})));
            String checkTaskName = sourceSet.getTaskName("check", "clojure");
            ClojureCheck check = (ClojureCheck)project.getTasks().create(checkTaskName, ClojureCheck.class);
            check.setDescription(String.format("Checks the %s Clojure source.", sourceSet.getName()));
            check.setSource(clojureSourceSet.getClojure());
            check.getClasspath().from(new Object[]{project.files(new Object[]{classpath})});
            sourceSet.getOutput().dir((Object)project.files(new Object[]{project.provider(() -> clojureSourceSet.getClojure().getSrcDirs())}));
            check.dependsOn(new Object[]{sourceSet.getClassesTaskName()});
            project.getTasks().getByName("check").dependsOn(new Object[]{check});
            String compileTaskName = sourceSet.getCompileTaskName("clojure");
            ClojureCompile compile = (ClojureCompile)project.getTasks().create(compileTaskName, ClojureCompile.class);
            compile.setDescription(String.format("Compiles the %s Clojure source.", sourceSet.getName()));
            compile.setSource(clojureSourceSet.getClojure());
            compile.getClasspath().from(new Object[]{project.files(new Object[]{classpath})});
            DirectoryProperty buildDir = project.getLayout().getBuildDirectory();
            String outputDirPath = String.format("classes/%s/%s", clojureSourceSet.getClojure().getName(), sourceSet.getName());
            Provider outputDir = buildDir.dir(outputDirPath);
            compile.getDestinationDir().set(outputDir);
            compile.dependsOn(new Object[]{sourceSet.getClassesTaskName()});
            String classesAotName = String.format("%sAot", sourceSet.getClassesTaskName());
            project.getTasks().create(classesAotName, task -> {
                task.dependsOn(new Object[]{compile});
                task.dependsOn(new Object[]{sourceSet.getClassesTaskName()});
            });
        });
    }

    private void configureModuleReplacements(Project project) {
        project.getDependencies().getModules().module((Object)"org.clojure:tools.nrepl", module -> {
            ComponentModuleMetadataDetails details = (ComponentModuleMetadataDetails)module;
            details.replacedBy((Object)"nrepl:nrepl", "nREPL was moved out of Clojure Contrib to its own project.");
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getVersion() {
        try (InputStream stream = ClojureBasePlugin.class.getResourceAsStream("/gradle-clojure.properties");){
            Properties props = new Properties();
            props.load(stream);
            String string = props.getProperty("version");
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

