/*
 * Decompiled with CFR 0.152.
 */
package gradle_clojure.plugin.clojure;

import gradle_clojure.plugin.clojure.ClojureBasePlugin;
import gradle_clojure.plugin.clojure.tasks.ClojureCompile;
import gradle_clojure.plugin.clojure.tasks.ClojureNRepl;
import gradle_clojure.plugin.clojure.tasks.ClojureSourceSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.testing.Test;
import org.gradle.jvm.tasks.Jar;

public class ClojurePlugin
implements Plugin<Project> {
    private static final String DEV_SOURCE_SET_NAME = "dev";

    public void apply(Project project) {
        project.getPlugins().apply(ClojureBasePlugin.class);
        project.getPlugins().apply(JavaPlugin.class);
        JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
        this.configureTest(project, javaConvention);
        this.configureAotJar(project, javaConvention);
        this.configureDev(project, javaConvention);
        project.getPlugins().withId("com.github.johnrengelman.shadow", plugin -> {
            Jar jar = (Jar)project.getTasks().getByName("shadowJar");
            jar.from(new Object[]{project.getTasks().getByName("compileClojure")});
        });
    }

    private void configureTest(Project project, JavaPluginConvention javaConvention) {
        SourceSet sourceSet = (SourceSet)javaConvention.getSourceSets().getByName("test");
        ClojureCompile compile = (ClojureCompile)project.getTasks().getByName(sourceSet.getCompileTaskName("clojure"));
        sourceSet.setRuntimeClasspath((FileCollection)project.files(new Object[]{compile, sourceSet.getRuntimeClasspath()}));
        project.getTasks().withType(Test.class, task -> task.setTestClassesDirs((FileCollection)project.files(new Object[]{compile, sourceSet.getOutput().getClassesDirs()})));
        compile.getNamespaces().add((Object)"gradle-clojure.tools.logger");
        compile.getNamespaces().add((Object)"gradle-clojure.tools.clojure-test-junit4");
    }

    private void configureAotJar(Project project, JavaPluginConvention javaConvention) {
        SourceSet sourceSet = (SourceSet)javaConvention.getSourceSets().getByName("main");
        ClojureSourceSet clojure = (ClojureSourceSet)new DslObject((Object)sourceSet).getConvention().getPlugins().get("clojure");
        Jar jar = (Jar)project.getTasks().create("aotJar", Jar.class);
        jar.from(new Object[]{sourceSet.getOutput().minus((FileCollection)project.files(new Object[]{clojure.getClojure().getSrcDirs()}))});
        jar.from(new Object[]{project.getTasks().getByName(sourceSet.getCompileTaskName("clojure"))});
        jar.dependsOn(new Object[]{String.format("%sAot", sourceSet.getClassesTaskName())});
    }

    private void configureDev(Project project, JavaPluginConvention javaConvention) {
        SourceSet main = (SourceSet)javaConvention.getSourceSets().getByName("main");
        SourceSet test = (SourceSet)javaConvention.getSourceSets().getByName("test");
        SourceSet dev = (SourceSet)javaConvention.getSourceSets().create(DEV_SOURCE_SET_NAME);
        Configuration nrepl = project.getConfigurations().getByName("nrepl");
        project.getConfigurations().getByName(dev.getCompileClasspathConfigurationName()).extendsFrom(new Configuration[]{nrepl});
        project.getConfigurations().getByName(dev.getRuntimeClasspathConfigurationName()).extendsFrom(new Configuration[]{nrepl});
        dev.setCompileClasspath((FileCollection)project.files(new Object[]{test.getOutput(), main.getOutput(), project.getConfigurations().getByName(dev.getCompileClasspathConfigurationName())}));
        dev.setRuntimeClasspath((FileCollection)project.files(new Object[]{dev.getAllSource(), dev.getOutput(), test.getAllSource(), test.getOutput(), main.getAllSource(), main.getOutput(), project.getConfigurations().getByName(dev.getRuntimeClasspathConfigurationName())}));
        Consumer<Function> devExtendsTest = getConfName -> {
            Configuration devConf = project.getConfigurations().getByName((String)getConfName.apply(dev));
            Configuration testConf = project.getConfigurations().getByName((String)getConfName.apply(test));
            devConf.extendsFrom(new Configuration[]{testConf});
        };
        devExtendsTest.accept(SourceSet::getCompileConfigurationName);
        devExtendsTest.accept(SourceSet::getImplementationConfigurationName);
        devExtendsTest.accept(SourceSet::getRuntimeConfigurationName);
        devExtendsTest.accept(SourceSet::getRuntimeOnlyConfigurationName);
        project.getTasks().create("clojureRepl", ClojureNRepl.class, task -> {
            task.setGroup("run");
            task.setDescription("Starts an nREPL server.");
            task.setClasspath(dev.getRuntimeClasspath());
            Stream.of(main, test, dev).forEach(sourceSet -> {
                task.dependsOn(new Object[]{project.getTasks().getByName(sourceSet.getCompileJavaTaskName())});
                task.dependsOn(new Object[]{project.getTasks().getByName(sourceSet.getProcessResourcesTaskName())});
            });
        });
    }
}

