/*
 * Decompiled with CFR 0.152.
 */
package gradle_clojure.plugin.clojurescript;

import gradle_clojure.plugin.clojure.ClojureBasePlugin;
import gradle_clojure.plugin.clojurescript.internal.DefaultClojureScriptSourceSet;
import gradle_clojure.plugin.clojurescript.tasks.ClojureScriptCompile;
import javax.inject.Inject;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.file.SourceDirectorySetFactory;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;

public class ClojureScriptBasePlugin
implements Plugin<Project> {
    private final SourceDirectorySetFactory sourceDirectorySetFactory;

    @Inject
    public ClojureScriptBasePlugin(SourceDirectorySetFactory sourceDirectorySetFactory) {
        this.sourceDirectorySetFactory = sourceDirectorySetFactory;
    }

    public void apply(Project project) {
        project.getPluginManager().apply(JavaBasePlugin.class);
        project.getPluginManager().apply(ClojureBasePlugin.class);
        this.configureSourceSetDefaults(project);
    }

    private void configureSourceSetDefaults(Project project) {
        ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().all(sourceSet -> {
            DefaultClojureScriptSourceSet clojurescriptSourceSet = new DefaultClojureScriptSourceSet("clojurescript", this.sourceDirectorySetFactory);
            new DslObject(sourceSet).getConvention().getPlugins().put("clojurescript", clojurescriptSourceSet);
            clojurescriptSourceSet.getClojureScript().srcDir((Object)String.format("src/%s/clojurescript", sourceSet.getName()));
            sourceSet.getResources().getFilter().exclude(element -> clojurescriptSourceSet.getClojureScript().contains(element.getFile()));
            sourceSet.getAllSource().source(clojurescriptSourceSet.getClojureScript());
            String compileTaskName = sourceSet.getCompileTaskName("clojurescript");
            ClojureScriptCompile compile = (ClojureScriptCompile)project.getTasks().create(compileTaskName, ClojureScriptCompile.class);
            compile.setDescription(String.format("Compiles the %s ClojureScript source.", sourceSet.getName()));
            compile.setSource(clojurescriptSourceSet.getClojureScript());
            Provider classpath = project.provider(() -> ((SourceSet)sourceSet).getCompileClasspath());
            compile.getClasspath().from(new Object[]{classpath});
            DirectoryProperty buildDir = project.getLayout().getBuildDirectory();
            String outputDirPath = String.format("classes/%s/%s", clojurescriptSourceSet.getClojureScript().getName(), sourceSet.getName());
            Provider outputDir = buildDir.dir(outputDirPath);
            compile.getDestinationDir().set(outputDir);
            String classesAotName = String.format("%sAot", sourceSet.getClassesTaskName());
            project.getTasks().getByName(classesAotName).dependsOn(new Object[]{compile});
        });
    }
}

