/*
 * Decompiled with CFR 0.152.
 */
package gradle_clojure.plugin.clojure;

import gradle_clojure.plugin.clojure.ClojureBasePlugin;
import gradle_clojure.plugin.clojure.ClojureBuild;
import gradle_clojure.plugin.clojure.ClojureExtension;
import gradle_clojure.plugin.common.internal.ClojureCommonPlugin;
import java.util.stream.Collectors;
import org.gradle.api.Plugin;
import org.gradle.api.Project;

public class ClojurePlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPlugins().apply(ClojureBasePlugin.class);
        project.getPlugins().apply(ClojureCommonPlugin.class);
        ClojureExtension extension = (ClojureExtension)project.getExtensions().getByType(ClojureExtension.class);
        this.configureBuilds(project, extension);
    }

    private void configureBuilds(Project project, ClojureExtension extension) {
        ClojureBuild main = (ClojureBuild)extension.getBuilds().getByName("main");
        main.checkAll();
        extension.getBuilds().matching(build -> build.getName().toLowerCase().contains("test")).all(test -> {
            test.aotAll();
            test.getAotNamespaces().add((Object)"gradle-clojure.tools.logger");
            test.getAotNamespaces().add((Object)"gradle-clojure.tools.clojure-test-junit4");
        });
        ClojureBuild dev = (ClojureBuild)extension.getBuilds().getByName("dev");
        dev.getCheckNamespaces().set(dev.getAllNamespaces().map(nses -> nses.stream().filter("user"::equals).collect(Collectors.toSet())));
    }
}

