/*
 * Decompiled with CFR 0.152.
 */
package gradle_clojure.plugin.clojurescript;

import gradle_clojure.plugin.clojure.tasks.ClojureNRepl;
import gradle_clojure.plugin.clojurescript.ClojureScriptBasePlugin;
import gradle_clojure.plugin.clojurescript.ClojureScriptExtension;
import gradle_clojure.plugin.common.internal.ClojureCommonPlugin;
import org.gradle.api.Plugin;
import org.gradle.api.Project;

public class ClojureScriptPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPlugins().apply(ClojureScriptBasePlugin.class);
        project.getPlugins().apply(ClojureCommonPlugin.class);
        ClojureScriptExtension extension = (ClojureScriptExtension)project.getExtensions().getByType(ClojureScriptExtension.class);
        this.configureBuilds(project, extension);
        this.configurePiggieback(project);
        this.configureFigwheel(project);
    }

    private void configureBuilds(Project project, ClojureScriptExtension extension) {
        ClojureNRepl repl = (ClojureNRepl)project.getTasks().getByName("clojureRepl");
        repl.getContextData().put("cljs-builds", extension.getBuilds());
    }

    private void configurePiggieback(Project project) {
        project.getDependencies().add("nrepl", (Object)"cider:piggieback:0.3.6");
        ClojureNRepl repl = (ClojureNRepl)project.getTasks().getByName("clojureRepl");
        repl.getDefaultMiddleware().add((Object)"cider.piggieback/wrap-cljs-repl");
    }

    private void configureFigwheel(Project project) {
        project.getDependencies().add("nrepl", (Object)"com.bhauman:figwheel-main:0.1.2");
    }
}

