/*
 * Decompiled with CFR 0.152.
 */
package gradle_clojure.plugin.clojurescript;

import gradle_clojure.plugin.clojurescript.tasks.ClojureScriptCompileOptions;
import gradle_clojure.plugin.clojurescript.tasks.ClojureScriptSourceSet;
import gradle_clojure.plugin.clojurescript.tasks.FigwheelOptions;
import groovy.lang.Closure;
import org.apache.commons.text.WordUtils;
import org.gradle.api.Action;
import org.gradle.api.Named;
import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;

public class ClojureScriptBuild
implements Named {
    private final String name;
    private final DirectoryProperty outputDir;
    private final Property<SourceSet> sourceSet;
    private final ClojureScriptCompileOptions compiler;
    private final FigwheelOptions figwheel;

    public ClojureScriptBuild(Project project, String name) {
        this.name = name;
        this.outputDir = project.getLayout().directoryProperty();
        this.sourceSet = project.getObjects().property(SourceSet.class);
        this.compiler = new ClojureScriptCompileOptions(project, this.outputDir);
        this.figwheel = new FigwheelOptions(project, this.outputDir);
        this.figwheel.getWatchDirs().from(new Object[]{this.getSourceRoots()});
    }

    public String getName() {
        return this.name;
    }

    public DirectoryProperty getOutputDir() {
        return this.outputDir;
    }

    public Property<SourceSet> getSourceSet() {
        return this.sourceSet;
    }

    Provider<FileCollection> getSourceRoots() {
        return this.getSourceSet().map(sourceSet -> {
            ClojureScriptSourceSet clojure = (ClojureScriptSourceSet)new DslObject(sourceSet).getConvention().getPlugins().get("clojurescript");
            return clojure.getClojureScript().getSourceDirectories();
        });
    }

    public boolean isCompilerConfigured() {
        return this.compiler.getOutputTo().isPresent() || this.compiler.getModules().values().stream().anyMatch(module -> module.getOutputTo().isPresent());
    }

    public ClojureScriptCompileOptions getCompiler() {
        return this.compiler;
    }

    public void compiler(Action<? super ClojureScriptCompileOptions> configureAction) {
        configureAction.execute((Object)this.compiler);
    }

    public void compiler(Closure<?> configureAction) {
        configureAction.setResolveStrategy(1);
        configureAction.setDelegate((Object)this.compiler);
        configureAction.call((Object)this.compiler);
    }

    public FigwheelOptions getFigwheel() {
        return this.figwheel;
    }

    public void figwheel(Action<? super FigwheelOptions> configureAction) {
        configureAction.execute((Object)this.figwheel);
    }

    public void figwheel(Closure<?> configureAction) {
        configureAction.setResolveStrategy(1);
        configureAction.setDelegate((Object)this.figwheel);
        configureAction.call((Object)this.figwheel);
    }

    String getTaskName(String task) {
        if ("main".equals(this.name)) {
            return String.format("%sClojureScript", task);
        }
        return String.format("%s%sClojureScript", task, WordUtils.capitalize((String)this.name));
    }
}

