/*
 * Decompiled with CFR 0.152.
 */
package gradle_clojure.plugin.clojurescript;

import gradle_clojure.plugin.clojurescript.ClojureScriptBuild;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;

public class ClojureScriptExtension {
    private final DirectoryProperty outputDir;
    private final NamedDomainObjectContainer<ClojureScriptBuild> builds;

    public ClojureScriptExtension(Project project) {
        this.outputDir = project.getLayout().directoryProperty();
        this.builds = project.container(ClojureScriptBuild.class, name -> {
            ClojureScriptBuild build = new ClojureScriptBuild(project, name);
            build.getOutputDir().set(this.outputDir.dir(name));
            return build;
        });
    }

    public DirectoryProperty getRootOutputDir() {
        return this.outputDir;
    }

    public NamedDomainObjectContainer<ClojureScriptBuild> getBuilds() {
        return this.builds;
    }

    public void builds(Action<? super NamedDomainObjectContainer<? super ClojureScriptBuild>> configureAction) {
        configureAction.execute(this.builds);
    }
}

