/*
 * Decompiled with CFR 0.152.
 */
package gradle_clojure.plugin.clojurescript.tasks;

import gradle_clojure.plugin.clojurescript.tasks.ClojureScriptCompileOptions;
import gradle_clojure.plugin.common.internal.ClojureExecSpec;
import gradle_clojure.plugin.common.internal.ClojureExecutor;
import gradle_clojure.plugin.common.internal.Namespaces;
import java.io.File;
import java.nio.charset.StandardCharsets;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.compile.ForkOptions;
import org.gradle.process.JavaForkOptions;

public class ClojureScriptCompile
extends DefaultTask {
    private final ClojureExecutor clojureExecutor = new ClojureExecutor(this.getProject());
    private ConfigurableFileCollection sourceRoots;
    private final DirectoryProperty destinationDir = this.getProject().getLayout().directoryProperty();
    private final ConfigurableFileCollection classpath;
    private ClojureScriptCompileOptions options;
    private final ForkOptions forkOptions;

    public ClojureScriptCompile() {
        this.sourceRoots = this.getProject().files(new Object[0]);
        this.classpath = this.getProject().files(new Object[0]);
        this.options = new ClojureScriptCompileOptions(this.getProject(), this.destinationDir);
        this.forkOptions = new ForkOptions();
    }

    @InputFiles
    @SkipWhenEmpty
    public FileCollection getSource() {
        return Namespaces.getSources((FileCollection)this.sourceRoots, Namespaces.CLOJURESCRIPT_EXTENSIONS);
    }

    @Internal
    public ConfigurableFileCollection getSourceRoots() {
        return this.sourceRoots;
    }

    @OutputDirectory
    public DirectoryProperty getDestinationDir() {
        return this.destinationDir;
    }

    @Classpath
    public ConfigurableFileCollection getClasspath() {
        return this.classpath;
    }

    @Nested
    public ClojureScriptCompileOptions getOptions() {
        return this.options;
    }

    public void setOptions(ClojureScriptCompileOptions options) {
        this.options = options;
    }

    @Nested
    public ForkOptions getForkOptions() {
        return this.forkOptions;
    }

    public void forkOptions(Action<? super ForkOptions> configureAction) {
        configureAction.execute((Object)this.forkOptions);
    }

    @TaskAction
    public void compile() {
        File outputDir = ((Directory)this.getDestinationDir().get()).getAsFile();
        if (!this.getProject().delete(new Object[]{outputDir})) {
            throw new GradleException("Cannot clean destination directory: " + outputDir.getAbsolutePath());
        }
        if (!outputDir.mkdirs()) {
            throw new GradleException("Cannot create destination directory: " + outputDir.getAbsolutePath());
        }
        FileCollection classpath = this.getClasspath().plus((FileCollection)this.getSourceRoots());
        this.clojureExecutor.exec((Action<ClojureExecSpec>)((Action)spec -> {
            spec.setClasspath(classpath);
            spec.setMain("gradle-clojure.tools.clojurescript-compiler");
            spec.args(this.getSourceRoots(), this.getOptions());
            spec.forkOptions((Action<JavaForkOptions>)((Action)fork -> {
                fork.setJvmArgs(this.forkOptions.getJvmArgs());
                fork.setMinHeapSize(this.forkOptions.getMemoryInitialSize());
                fork.setMaxHeapSize(this.forkOptions.getMemoryMaximumSize());
                fork.setDefaultCharacterEncoding(StandardCharsets.UTF_8.name());
            }));
        }));
    }
}

