/*
 * Decompiled with CFR 0.152.
 */
package gradle_clojure.plugin.clojure.tasks;

import gradle_clojure.plugin.clojure.tasks.ClojureCompile;
import gradle_clojure.plugin.clojure.tasks.ClojureReflection;
import gradle_clojure.plugin.common.internal.ClojureExecSpec;
import gradle_clojure.plugin.common.internal.ClojureExecutor;
import gradle_clojure.plugin.common.internal.Namespaces;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.compile.ForkOptions;
import org.gradle.process.JavaForkOptions;

public class ClojureCheck
extends DefaultTask {
    private static final Logger logger = Logging.getLogger(ClojureCompile.class);
    private final ClojureExecutor clojureExecutor = new ClojureExecutor(this.getProject());
    private final ConfigurableFileCollection sourceRoots = this.getProject().files(new Object[0]);
    private final ConfigurableFileCollection classpath = this.getProject().files(new Object[0]);
    private final RegularFileProperty outputFile = this.getProject().getObjects().fileProperty();
    private final Property<ClojureReflection> reflection = this.getProject().getObjects().property(ClojureReflection.class);
    private final ForkOptions forkOptions = new ForkOptions();
    private final SetProperty<String> namespaces = this.getProject().getObjects().setProperty(String.class);

    public ClojureCheck() {
        this.outputFile.set(new File(this.getTemporaryDir(), "internal.txt"));
        this.onlyIf(task -> !((Set)this.getNamespaces().getOrElse(Collections.emptySet())).isEmpty());
    }

    @InputFiles
    @SkipWhenEmpty
    public FileCollection getSource() {
        return Namespaces.getSources((FileCollection)this.sourceRoots, Namespaces.CLOJURE_EXTENSIONS);
    }

    @Internal
    public ConfigurableFileCollection getSourceRoots() {
        return this.sourceRoots;
    }

    @Classpath
    public ConfigurableFileCollection getClasspath() {
        return this.classpath;
    }

    @OutputFile
    public RegularFileProperty getInternalOutputFile() {
        return this.outputFile;
    }

    @Input
    public Property<ClojureReflection> getReflection() {
        return this.reflection;
    }

    @Nested
    public ForkOptions getForkOptions() {
        return this.forkOptions;
    }

    public void forkOptions(Action<? super ForkOptions> configureAction) {
        configureAction.execute((Object)this.forkOptions);
    }

    @Input
    public SetProperty<String> getNamespaces() {
        return this.namespaces;
    }

    @TaskAction
    public void check() {
        if (!this.getProject().delete(new Object[]{this.getTemporaryDir()})) {
            throw new GradleException("Cannot clean temporary directory: " + this.getTemporaryDir().getAbsolutePath());
        }
        Set namespaces = (Set)this.getNamespaces().getOrElse(Collections.emptySet());
        logger.info("Checking {}", (Object)String.join((CharSequence)", ", namespaces));
        FileCollection classpath = this.getClasspath().plus((FileCollection)this.getSourceRoots()).plus((FileCollection)this.getProject().files(new Object[]{this.getTemporaryDir()}));
        this.clojureExecutor.exec((Action<ClojureExecSpec>)((Action)spec -> {
            spec.setClasspath(classpath);
            spec.setMain("gradle-clojure.tools.clojure-loader");
            spec.args(this.getSourceRoots(), namespaces, this.getReflection());
            spec.forkOptions((Action<JavaForkOptions>)((Action)fork -> {
                fork.setJvmArgs(this.forkOptions.getJvmArgs());
                fork.setMinHeapSize(this.forkOptions.getMemoryInitialSize());
                fork.setMaxHeapSize(this.forkOptions.getMemoryMaximumSize());
                fork.setDefaultCharacterEncoding(StandardCharsets.UTF_8.name());
            }));
        }));
        Path output = ((RegularFile)this.getInternalOutputFile().get()).getAsFile().toPath();
        try {
            Files.write(output, Arrays.asList(Instant.now().toString()), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

