(ns clj-redis.core
  (:require [taoensso.carmine :as car :refer [wcar]]))

(def redis-connection-uri nil)

(def redis-conn (delay {:pool {} :spec {:uri redis-connection-uri}}))

(defmacro wcar* [& body] `(wcar @redis-conn ~@body))

(defmacro redis-cli [cmd & body]
  `(wcar @redis-conn (~(ns-resolve 'clj-redis.core (symbol (str "car/" (name cmd)))) ~@body)))
