(ns intoclj.util
  (:require [clojure.string :as str]))

(defmacro array-class [c]
  (let [s (with-meta (gensym) {:private true})]
    (symbol (eval `(def ~s (class (make-array ~c 0)))))))

(defn mapvals [f m]
  (into {} (for [[k v] m] [k (f v)])))

(defn mapkeys [f m]
  (into {} (for [[k v] m] [(f k) v])))

(defn ->map [entry-fn coll]
  (into {} (map entry-fn coll)))

(defn vals->map [key-fn vals]
  (->map (fn [v] [(key-fn v) v]) vals))

(defn transpose [xs]
  (if-not (empty? xs)
    (apply map list xs)))

(defn single? [coll]
  (= (count (take 2 coll)) 1))

(defn drop-suffix [s suf]
  (if (str/ends-with? s suf)
    (str/join (drop-last (count suf) s))
    s))

(defn rconcat [& args]
  (apply concat (reverse args)))
