/*
 * Decompiled with CFR 0.152.
 */
package com.metabase.macaw;

import com.metabase.macaw.AnalysisError;
import com.metabase.macaw.AnalysisErrorType;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.ParenthesedSelect;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.TableFunction;

public final class BasicTableExtractor {
    public static Set<Table> getTables(Statement statement) {
        try {
            if (statement instanceof Select) {
                return BasicTableExtractor.getTables((Select)statement);
            }
            throw new AnalysisError(AnalysisErrorType.INVALID_QUERY);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new AnalysisError(AnalysisErrorType.UNABLE_TO_PARSE, (Throwable)illegalArgumentException);
        }
    }

    private static Set<Table> getTables(Select select) {
        if (select instanceof PlainSelect) {
            return BasicTableExtractor.getTables(select.getPlainSelect());
        }
        throw new AnalysisError(AnalysisErrorType.UNSUPPORTED_EXPRESSION);
    }

    private static Set<Table> getTables(PlainSelect plainSelect) {
        if (plainSelect.getLateralViews() != null || plainSelect.getOracleHierarchical() != null || plainSelect.getWindowDefinitions() != null) {
            throw new AnalysisError(AnalysisErrorType.UNABLE_TO_PARSE);
        }
        if (plainSelect.getWithItemsList() != null) {
            throw new AnalysisError(AnalysisErrorType.UNSUPPORTED_EXPRESSION);
        }
        if (plainSelect.getFetch() != null || plainSelect.getFirst() != null || plainSelect.getForClause() != null || plainSelect.getForMode() != null || plainSelect.getForUpdateTable() != null || plainSelect.getForXmlPath() != null || plainSelect.getIntoTables() != null || plainSelect.getIsolation() != null || plainSelect.getSkip() != null) {
            throw new AnalysisError(AnalysisErrorType.INVALID_QUERY);
        }
        HashSet<Table> hashSet = new HashSet<Table>();
        for (Object object : plainSelect.getSelectItems()) {
            if (!(object.getExpression() instanceof ParenthesedSelect)) continue;
            throw new AnalysisError(AnalysisErrorType.UNSUPPORTED_EXPRESSION);
        }
        Consumer<FromItem> consumer = fromItem -> {
            Table table;
            if (fromItem instanceof Table) {
                table = (Table)fromItem;
                if (table.getName().contains("*")) {
                    throw new AnalysisError(AnalysisErrorType.INVALID_QUERY);
                }
            } else {
                if (fromItem instanceof TableFunction) {
                    throw new AnalysisError(AnalysisErrorType.INVALID_QUERY);
                }
                throw new AnalysisError(AnalysisErrorType.UNSUPPORTED_EXPRESSION);
            }
            hashSet.add(table);
        };
        if (plainSelect.getFromItem() != null) {
            Object object;
            consumer.accept(plainSelect.getFromItem());
            object = plainSelect.getJoins();
            if (object != null) {
                object.stream().map(Join::getFromItem).forEach(consumer);
            }
        }
        return hashSet;
    }
}

