/*
 * Decompiled with CFR 0.152.
 */
package com.metabase.macaw;

import com.metabase.macaw.AnalysisError;
import com.metabase.macaw.AnalysisErrorType;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import java.util.function.Consumer;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.ParenthesedSelect;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.TableFunction;

public final class CompoundTableExtractor {
    public static Set<Table> getTables(Statement statement) {
        try {
            if (statement instanceof Select) {
                return CompoundTableExtractor.accTables((Select)statement);
            }
            throw new AnalysisError(AnalysisErrorType.INVALID_QUERY);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new AnalysisError(AnalysisErrorType.UNABLE_TO_PARSE, (Throwable)illegalArgumentException);
        }
    }

    private static Set<Table> accTables(Select select) {
        HashSet<Table> hashSet = new HashSet<Table>();
        Stack<Set<String>> stack = new Stack<Set<String>>();
        CompoundTableExtractor.accTables(select, hashSet, stack);
        return hashSet;
    }

    private static void accTables(Select select, Set<Table> set, Stack<Set<String>> stack) {
        if (select instanceof PlainSelect) {
            CompoundTableExtractor.accTables(select.getPlainSelect(), set, stack);
        } else if (select instanceof ParenthesedSelect) {
            CompoundTableExtractor.accTables(((ParenthesedSelect)select).getSelect(), set, stack);
        } else if (select instanceof SetOperationList) {
            for (Select select2 : ((SetOperationList)select).getSelects()) {
                CompoundTableExtractor.accTables(select2, set, stack);
            }
        } else {
            throw new AnalysisError(AnalysisErrorType.UNSUPPORTED_EXPRESSION);
        }
    }

    private static void accTables(PlainSelect plainSelect, Set<Table> set, Stack<Set<String>> stack) {
        if (plainSelect.getLateralViews() != null || plainSelect.getOracleHierarchical() != null || plainSelect.getWindowDefinitions() != null) {
            throw new AnalysisError(AnalysisErrorType.UNABLE_TO_PARSE);
        }
        HashSet<String> hashSet = new HashSet<String>();
        stack.push(hashSet);
        if (plainSelect.getWithItemsList() != null) {
            for (Object object : plainSelect.getWithItemsList()) {
                if (object.isRecursive()) {
                    hashSet.add(object.getAlias().getName());
                }
                CompoundTableExtractor.accTables(object.getSelect(), set, stack);
                hashSet.add(object.getAlias().getName());
            }
        }
        if (plainSelect.getFetch() != null || plainSelect.getFirst() != null || plainSelect.getForClause() != null || plainSelect.getForMode() != null || plainSelect.getForUpdateTable() != null || plainSelect.getForXmlPath() != null || plainSelect.getIntoTables() != null || plainSelect.getIsolation() != null || plainSelect.getSkip() != null) {
            throw new AnalysisError(AnalysisErrorType.INVALID_QUERY);
        }
        for (Object object : plainSelect.getSelectItems()) {
            Expression expression = object.getExpression();
            if (!(expression instanceof Select)) continue;
            CompoundTableExtractor.accTables((Select)expression, set, stack);
        }
        Consumer<FromItem> consumer = fromItem -> {
            if (fromItem instanceof Table) {
                Table table = (Table)fromItem;
                String string = table.getName();
                if (stack.stream().noneMatch(set -> set.contains(string))) {
                    if (string.contains("*")) {
                        throw new AnalysisError(AnalysisErrorType.INVALID_QUERY);
                    }
                    set.add(table);
                }
            } else {
                if (fromItem instanceof TableFunction) {
                    throw new AnalysisError(AnalysisErrorType.INVALID_QUERY);
                }
                if (fromItem instanceof Select) {
                    CompoundTableExtractor.accTables((Select)fromItem, set, stack);
                } else if (fromItem != null) {
                    throw new AnalysisError(AnalysisErrorType.UNSUPPORTED_EXPRESSION);
                }
            }
        };
        if (plainSelect.getFromItem() != null) {
            Object object;
            consumer.accept(plainSelect.getFromItem());
            object = plainSelect.getJoins();
            if (object != null) {
                object.stream().map(Join::getFromItem).forEach(consumer);
            }
        }
        stack.pop();
    }
}

