/*
 * Decompiled with CFR 0.152.
 */
package io.github.michalmela;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.maven.wagon.AbstractWagon;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.resource.Resource;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.awssdk.services.s3.model.NoSuchBucketException;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.services.sso.auth.ExpiredTokenException;
import software.amazon.awssdk.utils.StringUtils;

public final class S3Wagon
extends AbstractWagon {
    private volatile S3Client s3;
    private volatile String bucket;
    private volatile String baseDirectory;

    protected void openConnectionInternal() {
        if (this.s3 == null) {
            this.bucket = this.repository.getHost();
            String basedir = this.repository.getBasedir();
            this.baseDirectory = basedir.startsWith("/") ? basedir.substring(1) : basedir;
            this.s3 = S3Wagon.s3(this.authenticationInfo, S3Wagon.awsHttpClient(this.getProxyInfo()));
        }
    }

    public boolean getIfNewer(String resourceName, File destination, long timestamp) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        if (timestamp == 0L || this.isNewer(resourceName, timestamp)) {
            this.get(resourceName, destination);
            return true;
        }
        return false;
    }

    public void get(String resourceName, File destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = new Resource(resourceName);
        this.fireGetInitiated(resource, destination);
        try {
            GetObjectRequest objectRequest = (GetObjectRequest)GetObjectRequest.builder().key(this.key(resourceName)).bucket(this.bucket).build();
            this.fireGetStarted(resource, destination);
            try (ResponseInputStream is = this.s3.getObject(objectRequest);){
                this.getTransfer(resource, destination, (InputStream)is);
            }
            this.fireGetCompleted(resource, destination);
        }
        catch (NoSuchBucketException | NoSuchKeyException e) {
            throw new ResourceDoesNotExistException(resourceName + " not found in S3", e);
        }
        catch (ExpiredTokenException e) {
            throw new AuthorizationException("S3 authorization error", (Throwable)e);
        }
        catch (IOException | S3Exception e) {
            throw new TransferFailedException("Transfer from S3 failed", e);
        }
    }

    public void put(File source, String destination) {
        PutObjectRequest putOb = (PutObjectRequest)PutObjectRequest.builder().bucket(this.bucket).key(this.key(destination)).build();
        this.s3.putObject(putOb, RequestBody.fromBytes((byte[])S3Wagon.getObjectFile(source)));
    }

    public void closeConnection() {
        this.s3.close();
        this.s3 = null;
        this.bucket = null;
        this.baseDirectory = null;
    }

    private boolean isNewer(String resourceName, long timestamp) throws ResourceDoesNotExistException, AuthorizationException, TransferFailedException {
        try {
            HeadObjectResponse headObject = this.headObject(resourceName);
            return headObject.lastModified().getEpochSecond() > timestamp;
        }
        catch (NoSuchBucketException | NoSuchKeyException e) {
            throw new ResourceDoesNotExistException(resourceName + " not found in S3", e);
        }
        catch (ExpiredTokenException e) {
            throw new AuthorizationException("S3 authorization error", (Throwable)e);
        }
        catch (AwsServiceException e) {
            throw new TransferFailedException("Transfer from S3 failed", (Throwable)e);
        }
    }

    private HeadObjectResponse headObject(String resourceName) {
        HeadObjectRequest headObjectRequest = (HeadObjectRequest)HeadObjectRequest.builder().bucket(this.bucket).key(this.key(resourceName)).build();
        return this.s3.headObject(headObjectRequest);
    }

    private String key(String resourceName) {
        return this.baseDirectory + resourceName;
    }

    private static S3Client s3(AuthenticationInfo authenticationInfo, SdkHttpClient httpClient) {
        S3ClientBuilder s3 = (S3ClientBuilder)S3Client.builder().httpClient(httpClient);
        if (S3Wagon.hasMinimumRequiredFields(authenticationInfo)) {
            s3.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)authenticationInfo.getUserName(), (String)authenticationInfo.getPassword())));
        }
        return (S3Client)s3.build();
    }

    private static boolean hasMinimumRequiredFields(AuthenticationInfo authenticationInfo) {
        return authenticationInfo != null && StringUtils.isNotBlank((CharSequence)authenticationInfo.getUserName()) && StringUtils.isNotBlank((CharSequence)authenticationInfo.getPassword());
    }

    private static SdkHttpClient awsHttpClient(ProxyInfo proxyInfo) {
        ApacheHttpClient.Builder httpClientBuilder = ApacheHttpClient.builder();
        if (proxyInfo != null) {
            httpClientBuilder.proxyConfiguration((ProxyConfiguration)ProxyConfiguration.builder().endpoint(URI.create(proxyInfo.getHost() + ":" + proxyInfo.getPort())).ntlmDomain(proxyInfo.getNtlmDomain()).ntlmWorkstation(proxyInfo.getNtlmHost()).username(proxyInfo.getUserName()).password(proxyInfo.getPassword()).build());
        }
        return httpClientBuilder.build();
    }

    public boolean resourceExists(String resourceName) throws TransferFailedException, AuthorizationException {
        try {
            this.headObject(resourceName);
            return true;
        }
        catch (NoSuchKeyException e) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] getObjectFile(File file) {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            byte[] bytesArray = new byte[(int)file.length()];
            fileInputStream.read(bytesArray);
            byte[] byArray = bytesArray;
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

