(ns missinterpret.flows.system.catalog.workflow
  (:require [missinterpret.anomalies.anomaly :refer [throw+]]
            [missinterpret.flows.system.state :refer [state-atom] :as s]
            [missinterpret.flows.utils :refer [opts]]))

;; Editing Fns ----------------------------------------------------------
;;

(defn catalog []
  (get @state-atom :workflow.catalog/loaded))


(defn lookup [id & {:keys [throw-missing] :as op}]
  (let [wf (get-in @state-atom [:workflow.catalog/loaded id])]
    (if (and (true? throw-missing) (nil? wf))
      (throw+
        {:from     ::lookup
         :category :anomaly.category/invalid
         :message  {:readable (str id " not in catalog")
                    :reasons  [:invalid/id]
                    :data     {:id id :opts op}}})
      wf)))


(defn lookup-in [id path & {:keys [throw-missing] :as op}]
  (let [wf (get-in @state-atom (concat [:workflow.catalog/loaded id] path))]
    (if (and (true? throw-missing) (nil? wf))
      (throw+
        {:from     ::lookup-in
         :category :anomaly.category/invalid
         :message  {:readable (str id " not in catalog")
                    :reasons  [:invalid/id]
                    :data     {:id id :opts op}}})
      wf)))


(defn add!
  [id value & {:keys [insert] :as op}]
  (let [insert? (-> (opts op) :insert true?)]
    (if (and insert? (some? (lookup id)))
      (throw+
        {:from     ::add!
         :category :anomaly.category/conflict
         :message  {:readable "Duplicate flow encountered that conflicts with catalog"
                    :reasons  [:invalid/flow]
                    :data     {:id id
                               :value value
                               :flow.catalog/value (lookup id)}}})
      (swap! state-atom assoc-in [:workflow.catalog/loaded id] value))))


(defn remove!
  [id]
  (s/dissoc-in! [:workflow.catalog/loaded id]))




