(ns missinterpret.flows.system.component
  (:require [missinterpret.flows.system.state :as state]
            [com.stuartsierra.component :as component]
            [missinterpret.flows.system.constructors :as cstr]
            ))

(defrecord WorkflowCatalog [wf-definitions flow-definitions args routes]
  component/Lifecycle
  (start [component]
    (let [catalog (cstr/flows-definition wf-definitions flow-definitions args routes)]
      (assoc component :flows.state/loaded (state/start catalog))))
  (stop [component] component))


(defn new-component
  ([wf-definitions]
   (new-component wf-definitions nil nil))
  ([wf-definitions flow-definitions]
   (new-component wf-definitions flow-definitions nil))
  ([wf-definitions flow-definitions routes]
   (new-component wf-definitions flow-definitions routes nil))
  ([wf-definitions flow-definitions routes args]
    (map->WorkflowCatalog {:wf-definitions wf-definitions
                           :wf-args args
                           :flow-definitions flow-definitions
                           :routes routes})))


