(ns missinterpret.flows.constructors
  "Constructors for entities. These only match schemas, the
  system namespaces are user-facing and perform more extensive runtime
  validation."
  (:require [clojure.pprint :refer [pprint]]
            [missinterpret.flows.utils :as utils.flows]
            [missinterpret.flows.xflow :as xf]
            [missinterpret.flows.schema :as schema]))

(defn workflow
  [id definition-or-flow & o]
  (let [definition (if (sequential? definition-or-flow) definition-or-flow [definition-or-flow])
        wf #:workflow{:id id :uuid (random-uuid) :definition definition}]
    (utils.flows/merge-opts wf o)))

(defn flow
  [id flow-fn & o]
  (let [f #:flow{:id id :uuid (random-uuid) :fn flow-fn}
        schema (schema/io flow-fn)]
    (cond-> (utils.flows/merge-opts f o)
            (some? schema) (with-meta schema))))

(defn default-flow
  [id default-fn & o]
  (let [flow-id (-> id name (str "-default-fn") keyword)
        f (xf/xflow flow-id (xf/default default-fn))
        schema (schema/io f)]
    (cond-> (utils.flows/merge-opts f o)
            (some? schema) (with-meta schema))))

(defn fn-flow
  [id fn-arg & o]
  (let [f (xf/xflow id (xf/->fn fn-arg))
        schema (schema/io f)]
    (cond-> (utils.flows/merge-opts f o)
            (some? schema) (with-meta schema))))

(defn expand-flow
  "Creates a flow from an arity-1 function."
  [id fn-arg & o]
  (let [f (xf/xflow id (xf/fn-expand fn-arg))
        schema (schema/io f)]
    (cond-> (utils.flows/merge-opts f o)
            (some? schema) (with-meta schema))))
