(ns missinterpret.flows.constructors
  "Constructors for entities. These only match schemas, the
  system namespaces are user-facing and perform more extensive runtime
  validation."
  (:require [clojure.pprint :refer [pprint]]
            [missinterpret.flows.utils :refer [extract opts]]
            [missinterpret.flows.xflow :as xf]
            [missinterpret.flows.spec :as spec]))

(defn workflow
  [id definition-or-flow & o]
  (let [definition (if (sequential? definition-or-flow) definition-or-flow [definition-or-flow])
        wf #:workflow{:id id :definition definition}]
    (if (some? o)
      (let [final-opts (-> (opts o)
                           (merge wf)
                           (extract spec/Workflow))]
        final-opts)
      wf)))

(defn flow
  [id flow-fn & o]
  (let [f #:flow{:id id :fn flow-fn}]
    (if (some? o)
      (-> (opts o)
          (merge f)
          (extract spec/Flow))
      f)))

(defn fn-flow
  "Creates a flow from an arity-1 function."
  ([id fn-arg]
   (xf/xflow id (xf/fn-expand fn-arg)))
  ([id fn-arg default-fn]
   (xf/xflow id (xf/fn-expand fn-arg) default-fn)))


