(ns missinterpret.flows.pedestal.route)

(defn func [r]
  (nth r 2))


(defn route-order [route-definition]
  (case (count route-definition)
    3 :simple
    5 :first
    7 :second))


(defn has-options? [r]
  (let [order (route-order r)]
    (or (= :first order) (= :second order))))


(defn options [r]
  (when (has-options? r)
    (let [k1 (nth r 3)
          val1 (nth r 4)
          k2 (nth r 5 :missing)
          val2 (nth r 6 :missing)]
      (-> {}
          (and (some? k1) (some? val1) (not= val1 :missing))
          (assoc k1 val1)
          (and (some? k2) (some? val2) (not= val2 :missing))
          (assoc k2 val2)))))


(defn route-name [r]
  (let [id (if (has-options? r) (:route-name (options r)) (str (func r)))]
    (keyword "route" id)))


(defn new-route [p-route interceptor]
  (let [path (nth p-route 0)
        env (nth p-route 1)]
    (if (has-options? p-route)
      (let [order (route-order p-route)]
        (cond
          (= :first order)
          [path env interceptor (nth p-route 3) (nth p-route 4)]

          (= :second order)
          [path env interceptor (nth p-route 3) (nth p-route 4) (nth p-route 5) (nth p-route 6)])))))



