(ns missinterpret.flows.pedestal.workflow
  (:require [missinterpret.anomalies.anomaly :refer [throw+]]))

(defn route-workflow [route]
  (let [{:flows/keys [workflow]} (meta route)]
    (if (nil? workflow)
      (throw+
        {:from     ::route-workflow
         :category :anomaly.category/invalid
         :message  {:readable "Route workflow is invalid"
                    :reasons  [:invalid.route/workflow]
                    :data     {:flows.pedestal/route route}}})
      workflow)))
