(ns missinterpret.flows.pedestal.routes
  (:require [clojure.pprint :refer [pprint]]
            [io.pedestal.interceptor :as i]
            [missinterpret.flows.predicates :refer [workflow?]]
            [missinterpret.anomalies.anomaly :refer [throw+]]
            [missinterpret.flows.pedestal.route :as r]
            [missinterpret.flows.pedestal.interceptor :as p.i]))


(defn flow-definition
  "Converts the interceptor 'definition' into a vector of flows."
  [flow-catalog func]
  (cond

    (keyword? func) func

    ;; Wrap each.
    ;;  This operates by recursion, so it can handle a DAG.
    ;;
    (vector? func)
    (reduce
      (fn [coll pfunc]
        (into coll (flow-definition flow-catalog pfunc)))
      []
      func)

    ;; Have pedestal try to convert to an interceptor
    ;; and create its flow.
    :else
    [(-> (i/interceptor func) p.i/to-flow)]))


(defn flows
  "Returns a vector of the flows defined by the passed interceptor 'definition'.
   This initiates the recursive flow-definition fn."
  [flow-catalog p-route]
  (->> (r/func p-route) (flow-definition flow-catalog)))


(defn route-workflow [p-route definition default-fn]
  (if (keyword? definition)
    definition
    (let [id (r/route-name p-route)
          args (when (some? default-fn) (default-fn))]
      (cond-> #:workflow{:id         id
                         :definition definition
                         :order      :interceptor}
              (some? args) (assoc :workflow/args args)))))


;; Primary transformation of pedestal route definition ---------------------------------
;; into matching interceptor and workflow
;;

; todo - have wf be the id key if this by ref
(defn defroute
  ([p-route]
   (defroute p-route))
  ([p-route default-fn]
    (let [flow-catalog {}
          def-flows (flows flow-catalog p-route)
          wf (route-workflow p-route def-flows default-fn)]
      (-> (r/new-route p-route (p.i/new-interceptor wf))
          (with-meta {:flows/workflow wf})))))



