(ns missinterpret.storage.store.spec-runtime
  (:require [missinterpret.storage.store.predicate :as pred.store]
            [missinterpret.storage.provider.predicate :as pred.prov]
            [missinterpret.storage.block.predicate :as pred.block]
            [missinterpret.storage.address.predicate :as pred.addr]))

;; Runtime Element ------------------------------------------------

(def StoreId
  [:map
   [:store.id/name    some?]
   [:store.id/uuid    uuid?]
   [:store.id/block   [:fn pred.store/block-store?]]
   [:store.id/content [:fn pred.store/content-store?]]])

(def Element
  [:map
   [:storage/block                     [:fn pred.block/block?]]
   [:storage/provider                  [:fn pred.prov/provider?]]
   [:storage/address  {:optional true} [:fn pred.addr/address?]]])

