(ns missinterpret.storage.store.content.core
  (:require [clojure.pprint :refer [pprint]]
            [missinterpret.storage.address.predicate :as pred.address]
            [missinterpret.storage.block.core :as core.block]
            [missinterpret.storage.block.predicate :as pred.block]
            [missinterpret.storage.provider.core :as core.prov]
            [missinterpret.storage.provider.predicate :as pred.prov]))

(defn address [{:storage/keys [provider block address] :as element}]
  (cond
    (pred.prov/provider? provider)  (core.prov/address provider)
    (pred.block/block? block)       (core.block/address block)
    (pred.address/address? address) address))