(ns missinterpret.storage.source.spec
  (:require [missinterpret.storage.utils.core :refer [uri?]]))

(def Memory
  [:map
   [:source.memory/format                        keyword?]
   [:source.memory/data                          some?]])

(def Source
  [:map {:closed true}
    [:source/name                     some?]
    [:source/kind                     keyword?]
    [:source/availability             keyword?]
    [:source/content-type             string?]
    [:source/ext                      string?]
    [:source/uri     {:optional true} [:fn uri?]]
    [:source/context {:optional true} map?]])



(def Sources
  [:set Source])