(ns missinterpret.storage.store.predicate-runtime
  (:require [clojure.pprint :refer [pprint]]
            [malli.core :as m]
            [missinterpret.storage.store.spec-storeid :as spec.storeid]
            [missinterpret.storage.protocols.store :as prot.store]))

;; Runtime ------------------------------------------------

(defn store-id? [id]
  (m/validate spec.storeid/StoreId id))

(defn store? [store]
  (try
    (let [id (prot.store/id store)]
      (store-id? id))
    (catch Exception _ false)))

(defn flow-store? [store]
  (and (store? store)
       (-> (prot.store/info store) :store.info/kind (= :store.kind/flow))))

(defn sync-store? [store]
  (and (store? store)
       (-> (prot.store/info store) :store.info/kind (= :store.kind/synchronous))))

