(ns missinterpret.storage.store.predicate-runtime
  (:require [clojure.pprint :refer [pprint]]
            [malli.core :as m]
            [missinterpret.storage.store.spec-stores :as spec.stores]
            [missinterpret.storage.protocols.store :as prot.store]))

;; Runtime ------------------------------------------------

(defn store-id? [id]
  (m/validate spec.stores/StoreId id))

(defn store? [store]
  (try
    (let [id (prot.store/id store)]
      (store-id? id))
    (catch Exception _ false)))

(defn flow-store? [store]
  (and (store? store)
       (-> (prot.store/info store) :store.info/kind (= spec.stores/flow-kind))))

(defn sync-store? [store]
  (and (store? store)
       (-> (prot.store/info store) :store.info/kind (= spec.stores/sync-kind))))

