(ns missinterpret.storage.provider.predicate
  (:require [clojure.pprint :refer [pprint]]
            [malli.core :as m]
            [missinterpret.storage.block.predicate :as pred.block]
            [missinterpret.storage.provider.spec :as spec]
            [missinterpret.storage.protocols.provider :as prot.provider]
            [missinterpret.storage.utils.core :as core.utils]))

(defn provider-args? [args]
  (m/validate spec/ProviderArgs args))

(defn info? [prov]
  (m/validate spec/ProviderInfo prov))

(defn content-args? [{:source.range/keys [start end] :as args}]
  (and (m/validate spec/ContentArgs args)
       (if (or (some? start) (some? end))
         (and (some? start) (some? end)
              (> end start))
         true)))

(defn content? [{:storage/keys [input-stream data] :as content}]
  (and (m/validate spec/Content content)
       (or (and
             (some? input-stream)
             (core.utils/input-stream? input-stream))
           (some? data))))

(defn provider? [prov]
  (try
    (if (nil? prov)
      false
      (let [p (if (and (map? prov) (contains? prov :storage/provider))
                (:storage/provider prov)
                prov)]
        (-> p prot.provider/info info?)))
    (catch Exception _ false)))

(defn equals?
  "Do the two content providers share:
   1. Have the same provider info?
   "
  [p1 p2]
  )