(ns missinterpret.storage.address.predicate
  (:require [malli.core :as m]
            [missinterpret.storage.address.spec :refer [Address address-id-len]]))

(defn address?
  "Does the data conform to the `:storage/address` spec?"
  [data]
  (if (some? (:storage/address data))
    (m/validate Address (:storage/address data))
    (m/validate Address data)))

(defn valid-address-id?
  "Predicate that returns true if the string conforms to the hash format"
  [s]
  (and (string? s)
       (let [length (count s)]
         (if (= length address-id-len)
           (->> (subs s 0 address-id-len)
                (re-matches #"[0-9a-fA-F]+"))
           false))))

(defn equivalent? [a1 a2]
  (if (and (address? a1) (address? a2))
    (= (:address/id a1) (:address/id a2))
    false))

