(ns missinterpret.storage.protocols.block)

(defprotocol Block

  (id [this]
    "Returns the `:storage.block/id that was used to initialize the block")

  (info [this]
    "General information about this content provider. May not be capable of all
     potential accessibility or storage actions for a given storage block")

  (data [this]
    "Returns block data which conforms to the `:storage/block` spec.")

  (address [this]
    "Returns the address information of the contents of the storage block")

  (metadata [this]
    "The metadata associated with the content represented by this block")

  (sources [this]
    "The set of sources that reference the block contents"))
