(ns missinterpret.storage.provider.spec
  (:require [clojure.java.io :as io]
            [malli.generator :as mg]
            [missinterpret.storage.protocols.provider :as prot.prov]
            [missinterpret.storage.source.spec :as spec.source]
            [missinterpret.storage.block.spec :as spec.block]
            [missinterpret.storage.block.predicate :as pred.block]))

(def ProviderArgs
  [:map
   [:storage/block          [:fn {:gen/return (spec.block/block)} pred.block/block?]]
   [:source/name            {:optional true} some?]
   [:throw-when-no-sources? {:optional true} boolean?]])


(def ProviderInfo
  [:map
   [:provider.info/kind some?]
   [:provider.info/version some?]])


(def ContentArgs
  [:map
   [:storage/source     {:optional true} spec.source/Source]
   [:source/name        {:optional true} some?]
   [:source.range/start {:optional true} integer?]
   [:source.range/end   {:optional true} integer?]])


(def Content
  [:map {:closed true}
   [:storage/source                        spec.source/Source]
   [:storage/input-stream {:optional true} some?]
   [:storage/data         {:optional true} some?]])


;; Generator -------------------------------------------------

(defn provider []
  (reify
    prot.prov/ContentProvider
    (info [_] #:provider.info{:kind ::empty :version "0"})
    (block [_] (spec.block/block))
    (available-sources [_] #{})
    (content [_ _]
      {:storage/source (mg/generate spec.source/Source)
       :input-stream (io/input-stream (.getBytes "generated"))})))
