(ns missinterpret.storage.store.spec-stores
  (:require [malli.generator :as mg]
            [missinterpret.storage.protocols.block-store :as prot.block-store]
            [missinterpret.storage.protocols.content-store :as prot.content-store]
            [missinterpret.storage.store.spec :as spec.store]
            [missinterpret.storage.store.predicate :as pred.store]))

;; Generator ---------------------------------------------------------

(defn block-store []
  ;; NOTE: Only generates an ID as the spec only checks the id method
  (reify
    prot.block-store/BlockStore
    (id [_] (mg/generate spec.store/BlockStoreId))
    (info [_] nil)
    (exists? [_ _] nil)
    (query [_ _] nil)
    (add! [_ _] nil)
    (remove! [_ _] nil)))

(defn content-store []
  ;; NOTE: Only generates an ID as the spec only checks the id method
  (reify
    prot.content-store/ContentStore
    (id [_] (mg/generate spec.store/ContentStoreId))
    (info [_] nil)
    (exists? [_ _] nil)
    (provider [_ _] nil)
    (source [_ _] nil)
    (add! [_ _] nil)
    (remove! [_ _] nil)
    (availability! [_ _] nil)))


;; Runtime Element ------------------------------------------------

(def StoreId
  [:map
   [:store.id/name    some?]
   [:store.id/uuid    uuid?]
   [:store.id/block   [:fn {:gen/return (block-store)}   pred.store/block-store?]]
   [:store.id/content [:fn {:gen/return (content-store)} pred.store/content-store?]]])

;; Store Kinds

(def flow-kind :store.kind/flow)
(def sync-kind :store.kind/synchronous)