/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public class Vect<E>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private E[] elementData;
    private int elementCount = 0;

    public Vect() {
        this(10);
    }

    public Vect(int initialCapacity) {
        this.elementData = initialCapacity == 0 ? new Object[0] : new Object[initialCapacity];
    }

    public Vect(Vector<E> v) {
        this(v.size());
        int sz = v.size();
        for (int i = 0; i < sz; ++i) {
            this.addElement(v.elementAt(i));
        }
    }

    public final void addElement(E obj) {
        if (this.elementCount == this.elementData.length) {
            this.ensureCapacity(this.elementCount + 1);
        }
        this.elementData[this.elementCount++] = obj;
    }

    public final Vect<E> concat(Vect<E> elems) {
        int i;
        Vect<E> v = new Vect<E>();
        for (i = 0; i < this.elementCount; ++i) {
            v.addElement(this.elementData[i]);
        }
        for (i = 0; i < elems.size(); ++i) {
            v.addElement(elems.elementAt(i));
        }
        return v;
    }

    public int capacity() {
        return this.elementData.length;
    }

    public Object clone() {
        Vect<E> v = new Vect<E>(this.elementData.length);
        System.arraycopy(this.elementData, 0, v.elementData, 0, this.elementCount);
        v.elementCount = this.elementCount;
        return v;
    }

    public final boolean contains(Object elem) {
        return this.indexOf(elem) != -1;
    }

    public final void copyInto(Object[] anArray) {
        System.arraycopy(this.elementData, 0, anArray, 0, this.elementCount);
    }

    public final E elementAt(int index) {
        return this.elementData[index];
    }

    public Enumeration<E> elements() {
        return new Enumerator();
    }

    public final void ensureCapacity(int minCapacity) {
        if (this.elementData.length < minCapacity) {
            int newCapacity = this.elementData.length + this.elementData.length;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            E[] oldBuffer = this.elementData;
            this.elementData = new Object[newCapacity];
            System.arraycopy(oldBuffer, 0, this.elementData, 0, this.elementCount);
        }
    }

    public final Object firstElement() {
        return this.elementData[0];
    }

    public final int indexOf(Object elem) {
        return this.indexOf(elem, 0);
    }

    public final int indexOf(Object elem, int index) {
        for (int pos = index; pos < this.elementCount; ++pos) {
            if (!elem.equals(this.elementData[pos])) continue;
            return pos;
        }
        return -1;
    }

    public final void insertElementAt(E obj, int index) {
        if (this.elementCount == this.elementData.length) {
            this.ensureCapacity(this.elementCount + 1);
        }
        if (index > this.elementCount || index < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (index < this.elementCount) {
            System.arraycopy(this.elementData, index, this.elementData, index + 1, this.elementCount - index);
        }
        this.elementData[index] = obj;
        ++this.elementCount;
    }

    public final boolean isEmpty() {
        return this.elementCount == 0;
    }

    public final Object lastElement() {
        return this.elementData[this.elementCount - 1];
    }

    public final void removeLastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        --this.elementCount;
        this.elementData[this.elementCount] = null;
    }

    public final void setElementAt(E obj, int index) {
        this.elementData[index] = obj;
    }

    public final void removeElementAt(int index) {
        for (int i = index + 1; i < this.elementCount; ++i) {
            this.elementData[i - 1] = this.elementData[i];
        }
        --this.elementCount;
        this.elementData[this.elementCount] = null;
    }

    public final void removeAll(int cnt) {
        this.elementCount = cnt;
    }

    public final Object pop() {
        Object elem = this.lastElement();
        this.removeLastElement();
        return elem;
    }

    public final void push(E elem) {
        this.addElement(elem);
    }

    public final int size() {
        return this.elementCount;
    }

    public final int hashCode() {
        int code = 0;
        for (int i = 0; i < this.elementCount; ++i) {
            code ^= this.elementData[i].hashCode();
        }
        return code;
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof Vect)) {
            return false;
        }
        Vect v = (Vect)obj;
        if (v.size() != this.elementCount) {
            return false;
        }
        for (int i = 0; i < this.elementCount; ++i) {
            if (this.elementData[i].equals(v.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("{");
        if (this.size() != 0) {
            buf.append(this.elementAt(0).toString());
        }
        for (int i = 1; i < this.size(); ++i) {
            buf.append(",");
            buf.append(this.elementAt(i).toString());
        }
        buf.append("}");
        return buf.toString();
    }

    final class Enumerator
    implements Enumeration<E> {
        int index = 0;

        Enumerator() {
        }

        @Override
        public final boolean hasMoreElements() {
            return this.index < Vect.this.elementCount;
        }

        @Override
        public final E nextElement() {
            return Vect.this.elementData[this.index++];
        }
    }
}

