/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.distributed;

import java.io.EOFException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import tlc2.TLCGlobals;
import tlc2.output.MP;
import tlc2.tool.TLCState;
import tlc2.tool.WorkerException;
import tlc2.tool.distributed.TLCServer;
import tlc2.tool.distributed.TLCWorkerRMI;
import tlc2.tool.distributed.TLCWorkerSmartProxy;
import tlc2.tool.distributed.selector.IBlockSelector;
import tlc2.tool.queue.IStateQueue;
import tlc2.util.BitVector;
import tlc2.util.IdThread;

public class TLCServerThread
extends IdThread {
    private static int COUNT = 0;
    private int receivedStates;
    private int sentStates;
    private double cacheRateHitRatio = -1.0;
    private final IBlockSelector selector;
    private TLCState[] states = new TLCState[0];
    private final TLCTimerTask task;
    private final Timer keepAliveTimer;
    private final AtomicBoolean cleanupGlobals = new AtomicBoolean(true);
    private final ExecutorService executorService;
    private final TLCWorkerRMI worker;
    private final TLCServer tlcServer;
    private URI uri;

    public TLCServerThread(TLCWorkerRMI worker, URI aURI, TLCServer tlc, ExecutorService es, IBlockSelector aSelector) {
        super(COUNT++);
        this.executorService = es;
        this.tlcServer = tlc;
        this.selector = aSelector;
        this.uri = aURI;
        this.keepAliveTimer = new Timer("TLCWorker KeepAlive Timer [" + this.uri.toASCIIString() + "]", true);
        this.worker = new TLCWorkerSmartProxy(worker);
        String i = String.format("%03d", this.myGetId());
        this.setName("TLCWorkerThread-" + i + "-[" + this.uri.toASCIIString() + "]");
        this.task = new TLCTimerTask();
        this.keepAliveTimer.schedule((TimerTask)this.task, 10000L, 60000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        block38: {
            TLCGlobals.incNumWorkers();
            newStates = null;
            newFps = null;
            stateQueue = this.tlcServer.stateQueue;
            try {
                block29: while (true) {
                    this.states = this.selector.getBlocks(stateQueue, this.worker);
                    if (this.states == null) {
                        var4_5 = this.tlcServer;
                        synchronized (var4_5) {
                            this.tlcServer.setDone();
                            this.tlcServer.notify();
                        }
                        stateQueue.finishAll();
                        return;
                    }
                    if (this.states.length == 0) continue;
                    this.sentStates += this.states.length;
                    workDone = false;
                    while (!workDone) {
                        try {
                            res = this.worker.getNextStates(this.states);
                            newStates = res.getNextStates();
                            this.receivedStates += newStates[0].size();
                            newFps = res.getNextFingerprints();
                            workDone = true;
                            this.task.setLastInvocation(System.currentTimeMillis());
                            this.tlcServer.addStatesGeneratedDelta(res.getStatesComputedDelta());
                        }
                        catch (RemoteException e) {
                            if (this.isRecoverable(e) && this.states.length > 1) {
                                MP.printMessage(7007, Integer.toString(this.states.length / 2));
                                stateQueue.sEnqueue(this.states);
                                this.selector.setMaxTXSize(this.states.length / 2);
                                continue block29;
                            }
                            MP.printMessage(7006, this.getUri().toString());
                            this.handleRemoteWorkerLost(stateQueue);
                            try {
                                this.cacheRateHitRatio = this.worker.getCacheRateRatio();
                            }
                            catch (RemoteException e) {
                                MP.printWarning(1000, "Failed to read remote worker cache statistic (Expect to see a negative chache hit rate. Does not invalidate model checking results)");
                            }
                            this.keepAliveTimer.cancel();
                            this.states = new TLCState[0];
                            return;
                        }
                        catch (NullPointerException e) {
                            MP.printMessage(7006, "\n" + this.throwableToString(e));
                            this.handleRemoteWorkerLost(stateQueue);
                            try {
                                this.cacheRateHitRatio = this.worker.getCacheRateRatio();
                            }
                            catch (RemoteException e) {
                                MP.printWarning(1000, "Failed to read remote worker cache statistic (Expect to see a negative chache hit rate. Does not invalidate model checking results)");
                            }
                            this.keepAliveTimer.cancel();
                            this.states = new TLCState[0];
                            return;
                        }
                    }
                    visited = this.tlcServer.fpSetManager.putBlock(newFps, this.executorService);
                    i = 0;
                    while (true) {
                        if (i < visited.length) ** break;
                        continue block29;
                        iter = new BitVector.Iter(visited[i]);
                        while ((index = iter.next()) != -1) {
                            state = newStates[i].elementAt(index);
                            fp = newFps[i].elementAt(index);
                            state.uid = this.tlcServer.trace.writeState(state, fp);
                            stateQueue.sEnqueue(state);
                        }
                        ++i;
                    }
                    break;
                }
                {
                    catch (Throwable e) {
                        state1 = null;
                        state2 = null;
                        if (e instanceof WorkerException) {
                            state1 = ((WorkerException)e).state1;
                            state2 = ((WorkerException)e).state2;
                        }
                        if (!this.tlcServer.setErrState(state1, true)) break block38;
                        if (state1 != null) {
                            try {
                                this.tlcServer.trace.printTrace(state1, state2);
                            }
                            catch (Exception e1) {
                                MP.printError(1000, e1);
                            }
                        } else {
                            MP.printError(1000, e);
                        }
                        stateQueue.finishAll();
                        var7_17 = this.tlcServer;
                        synchronized (var7_17) {
                            this.tlcServer.notify();
                            break block38;
                        }
                    }
                    catch (Throwable var13_23) {
                        throw var13_23;
                    }
                }
            }
            finally {
                try {
                    this.cacheRateHitRatio = this.worker.getCacheRateRatio();
                }
                catch (RemoteException e) {
                    MP.printWarning(1000, "Failed to read remote worker cache statistic (Expect to see a negative chache hit rate. Does not invalidate model checking results)");
                }
                this.keepAliveTimer.cancel();
                this.states = new TLCState[0];
            }
        }
    }

    private boolean isRecoverable(Exception e) {
        Throwable cause = e.getCause();
        return cause instanceof EOFException && cause.getMessage() == null || cause instanceof RemoteException && cause.getCause() instanceof OutOfMemoryError;
    }

    private String throwableToString(Exception e) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        e.printStackTrace(printWriter);
        return ((Object)result).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRemoteWorkerLost(IStateQueue stateQueue) {
        this.keepAliveTimer.cancel();
        if (this.cleanupGlobals.compareAndSet(true, false)) {
            this.tlcServer.removeTLCServerThread(this);
            if (stateQueue != null) {
                stateQueue.sEnqueue(this.states != null ? this.states : new TLCState[]{});
            }
            this.states = new TLCState[0];
            if (stateQueue != null) {
                IStateQueue iStateQueue = stateQueue;
                synchronized (iStateQueue) {
                    stateQueue.notifyAll();
                }
            }
            TLCGlobals.decNumWorkers();
        }
    }

    public int getCurrentSize() {
        return this.states.length;
    }

    public URI getUri() {
        return this.uri;
    }

    public int getReceivedStates() {
        return this.receivedStates;
    }

    public int getSentStates() {
        return this.sentStates;
    }

    public double getCacheRateRatio() {
        return this.cacheRateHitRatio;
    }

    private class TLCTimerTask
    extends TimerTask {
        private long lastInvocation = 0L;

        private TLCTimerTask() {
        }

        @Override
        public void run() {
            long now = new Date().getTime();
            if (this.lastInvocation == 0L || now - this.lastInvocation > 60000L) {
                try {
                    if (!TLCServerThread.this.worker.isAlive()) {
                        TLCServerThread.this.handleRemoteWorkerLost(((TLCServerThread)TLCServerThread.this).tlcServer.stateQueue);
                    }
                }
                catch (RemoteException e) {
                    TLCServerThread.this.handleRemoteWorkerLost(((TLCServerThread)TLCServerThread.this).tlcServer.stateQueue);
                }
            }
        }

        public void setLastInvocation(long lastInvocation) {
            this.lastInvocation = lastInvocation;
        }
    }
}

