/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.liveness;

import tlc2.tool.EvalException;
import tlc2.tool.liveness.BEGraphNode;
import tlc2.tool.liveness.NodeTable;
import tlc2.util.MemObjectQueue;
import tlc2.util.MemObjectStack;
import tlc2.util.Vect;

public class BEGraph {
    public Vect<BEGraphNode> initNodes = new Vect();
    public String metadir;
    public NodeTable allNodes;

    public BEGraph(String metadir, boolean isBT) {
        this.metadir = metadir;
        this.allNodes = new NodeTable(127, isBT);
    }

    public final void resetNumberField() {
        MemObjectStack stack = new MemObjectStack(this.metadir, "resetstack");
        for (int i = 0; i < this.initNodes.size(); ++i) {
            BEGraphNode node = this.initNodes.elementAt(i);
            if (node.resetNumberField() == 0L) continue;
            stack.push(this.initNodes.elementAt(i));
        }
        while (stack.size() != 0) {
            BEGraphNode node = (BEGraphNode)stack.pop();
            for (int i = 0; i < node.nextSize(); ++i) {
                BEGraphNode node1 = node.nextAt(i);
                if (node1.resetNumberField() == 0L) continue;
                stack.push(node1);
            }
        }
    }

    public final BEGraphNode getInitNode(int i) {
        return this.initNodes.elementAt(i);
    }

    public final void addInitNode(BEGraphNode node) {
        this.initNodes.addElement(node);
    }

    public final int initSize() {
        return this.initNodes.size();
    }

    public static BEGraphNode[] getPath(BEGraphNode start2, BEGraphNode end) {
        if (start2.equals(end)) {
            start2.setParent(null);
        } else {
            boolean unseen = start2.getVisited();
            MemObjectQueue queue = new MemObjectQueue(null);
            start2.flipVisited();
            queue.enqueue(new NodeAndParent(start2, null));
            boolean found = false;
            while (!found) {
                NodeAndParent np = (NodeAndParent)queue.dequeue();
                if (np == null) {
                    throw new EvalException(2159);
                }
                BEGraphNode curNode = np.node;
                for (int i = 0; i < curNode.nextSize(); ++i) {
                    BEGraphNode nextNode = curNode.nextAt(i);
                    if (nextNode.getVisited() != unseen) continue;
                    if (nextNode.equals(end)) {
                        end.setParent(curNode);
                        found = true;
                        break;
                    }
                    nextNode.flipVisited();
                    queue.enqueue(new NodeAndParent(nextNode, curNode));
                }
                curNode.setParent(np.parent);
            }
        }
        Vect<BEGraphNode> path = new Vect<BEGraphNode>();
        for (BEGraphNode curNode = end; curNode != null; curNode = curNode.getParent()) {
            path.addElement(curNode);
        }
        int sz = path.size();
        BEGraphNode[] bpath = new BEGraphNode[sz];
        for (int i = 0; i < sz; ++i) {
            bpath[i] = (BEGraphNode)path.elementAt(sz - i - 1);
        }
        return bpath;
    }

    public final String toString() {
        StringBuffer buf = new StringBuffer();
        int sz = this.initNodes.size();
        if (sz != 0) {
            boolean seen = this.getInitNode(0).getVisited();
            for (int i = 0; i < this.initNodes.size(); ++i) {
                BEGraphNode node = this.getInitNode(i);
                node.toString(buf, seen);
            }
        }
        return buf.toString();
    }

    private static class NodeAndParent {
        BEGraphNode node;
        BEGraphNode parent;

        NodeAndParent(BEGraphNode node, BEGraphNode parent) {
            this.node = node;
            this.parent = parent;
        }
    }
}

