/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import tlc2.util.ObjectStack;
import util.Assert;
import util.FileUtil;

public final class MemObjectStack
extends ObjectStack {
    private static final int InitialSize = 4096;
    private static final int GrowthFactor = 2;
    private Object[] states = new Object[4096];
    private String filename;

    public MemObjectStack(String metadir, String name) {
        this.filename = metadir + FileUtil.separator + name;
    }

    @Override
    final void enqueueInner(Object state) {
        if (this.len == this.states.length) {
            int newLen = Math.max(1, this.len * 2);
            Object[] newStates = new Object[newLen];
            System.arraycopy(this.states, 0, newStates, 0, this.len);
            this.states = newStates;
        }
        this.states[this.len] = state;
    }

    @Override
    final Object dequeueInner() {
        int head = this.len - 1;
        Object res = this.states[head];
        this.states[head] = null;
        return res;
    }

    @Override
    public final void beginChkpt() throws IOException {
        String tmpfile = this.filename + ".tmp";
        ObjectOutputStream oos = FileUtil.newOBFOS((String)tmpfile);
        oos.writeInt(this.len);
        for (int i = 0; i < this.len; ++i) {
            oos.writeObject(this.states[i++]);
        }
        oos.close();
    }

    @Override
    public final void commitChkpt() throws IOException {
        String oldName = this.filename + ".chkpt";
        File oldChkpt = new File(oldName);
        String newName = this.filename + ".tmp";
        File newChkpt = new File(newName);
        if (!newChkpt.renameTo(oldChkpt)) {
            throw new IOException("MemObjectStack.commitChkpt: cannot delete " + oldChkpt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void recover() throws IOException {
        String chkptfile = this.filename + ".chkpt";
        ObjectInputStream ois = FileUtil.newOBFIS((String)chkptfile);
        this.len = ois.readInt();
        try {
            for (int i = 0; i < this.len; ++i) {
                this.states[i] = ois.readObject();
            }
        }
        catch (ClassNotFoundException e) {
            Assert.fail((int)2126, (String)e.getMessage());
        }
        finally {
            ois.close();
        }
    }
}

