/*
 * Decompiled with CFR 0.152.
 */
package tlc2.pprint;

import tlc2.pprint.Node;
import tlc2.pprint.ParseException;

public class Parse {
    private static final char setOpen = '{';
    private static final char setClose = '}';
    private static final char seqOpen = '<';
    private static final char seqClose = '>';
    private static final char recOpen = '[';
    private static final char recClose = ']';
    private static final String recDiv = "|->";
    private static final char funOpen = '(';
    private static final char funClose = ')';
    private static final String funDiv = ":>";
    private static final String funSep = "@@";
    private static final String intDiv = "..";
    private static final String ssDiv = "SUBSET";

    public static Node parse(String string, int index) throws ParseException {
        if (string == null) {
            throw new ParseException("TLC Bug: while formating output, the formatter was called with a null string for a value");
        }
        if (string.length() == 0) {
            throw new ParseException("TLC Bug: while formating output, the formatter was called with an empty string for a value");
        }
        if (index < 0 || index > string.length() - 1) {
            throw new ParseException("TLC Bug: while formating output, the formatter was called with a string " + string + " for a value and an index " + index + " out of bounds");
        }
        index = Parse.skipWhitespace(string, index);
        if (string.charAt(index) == '{') {
            return Parse.parseSet(string, index);
        }
        if (string.charAt(index) == '<') {
            return Parse.parseSequence(string, index);
        }
        if (string.charAt(index) == '[') {
            return Parse.parseRecord(string, index);
        }
        if (string.charAt(index) == '(') {
            return Parse.parseFunction(string, index);
        }
        if (string.regionMatches(index, ssDiv, 0, ssDiv.length())) {
            return Parse.parseSubset(string, index);
        }
        return Parse.parseConstant(string, index);
    }

    private static Node parseSet(String string, int index) throws ParseException {
        int first = index;
        int last = index;
        try {
            Node node = new Node(string, first, 2);
            Node firstelement = null;
            Node lastelement = null;
            ++last;
            last = Parse.skipWhitespace(string, last);
            while (string.charAt(last) != '}') {
                Node elt = Parse.parse(string, last);
                if (firstelement == null) {
                    firstelement = elt;
                    lastelement = elt;
                } else {
                    lastelement.next(elt);
                    lastelement = elt;
                }
                last = elt.last() + 1;
                last = Parse.skipWhitespace(string, last);
                if (string.charAt(last) == ',') {
                    ++last;
                }
                last = Parse.skipWhitespace(string, last);
            }
            node.children(firstelement);
            node.last(last);
            return node;
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ParseException("TLC Bug: while formating output, the formatter ran off the end of the string while parsing a set starting at index " + index + " in the value " + string + "\n" + e.getMessage());
        }
        catch (ParseException e) {
            throw e;
        }
    }

    private static Node parseSequence(String string, int index) throws ParseException {
        int first = index;
        int last = index;
        try {
            Node node = new Node(string, first, 3);
            Node firstelement = null;
            Node lastelement = null;
            ++last;
            ++last;
            last = Parse.skipWhitespace(string, last);
            while (string.charAt(last) != '>') {
                Node elt = Parse.parse(string, last);
                if (firstelement == null) {
                    firstelement = elt;
                    lastelement = elt;
                } else {
                    lastelement.next(elt);
                    lastelement = elt;
                }
                last = elt.last() + 1;
                last = Parse.skipWhitespace(string, last);
                if (string.charAt(last) == ',') {
                    ++last;
                }
                last = Parse.skipWhitespace(string, last);
            }
            node.children(firstelement);
            node.last(++last);
            return node;
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ParseException("TLC Bug: while formating output, the formatter ran off the end of the string while parsing a sequence starting at index " + index + " in the value " + string + "\n" + e.getMessage());
        }
        catch (ParseException e) {
            throw e;
        }
    }

    private static Node parseRecord(String string, int index) throws ParseException {
        int first = index;
        int last = index;
        try {
            Node node = new Node(string, first, 4);
            Node firstelement = null;
            Node lastelement = null;
            ++last;
            last = Parse.skipWhitespace(string, last);
            while (string.charAt(last) != ']') {
                Node elt = Parse.parseRecordPair(string, last);
                if (firstelement == null) {
                    firstelement = elt;
                    lastelement = elt;
                } else {
                    lastelement.next(elt);
                    lastelement = elt;
                }
                last = elt.last() + 1;
                last = Parse.skipWhitespace(string, last);
                if (string.charAt(last) == ',') {
                    ++last;
                }
                last = Parse.skipWhitespace(string, last);
            }
            node.children(firstelement);
            node.last(last);
            return node;
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ParseException("TLC Bug: while formating output, the formatter ran off the end of the string while parsing a record starting at index " + index + " in the value " + string + "\n" + e.getMessage());
        }
        catch (ParseException e) {
            throw e;
        }
    }

    private static Node parseRecordPair(String string, int index) throws ParseException {
        int first = index;
        int last = index;
        try {
            Node node = new Node(string, first, 5);
            Node field = null;
            Node value = null;
            field = Parse.parse(string, last);
            last = field.last() + 1;
            last = Parse.skipWhitespace(string, last);
            if (!string.regionMatches(last, recDiv, 0, recDiv.length())) {
                throw new ParseException("TLC Bug: while formating output, the formatter couldn't find the token |-> while parsing a record field/value pair starting at index " + index + " in value " + string);
            }
            last += recDiv.length();
            last = Parse.skipWhitespace(string, last);
            value = Parse.parse(string, last);
            field.next(value);
            node.children(field);
            node.last(value.last());
            return node;
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ParseException("TLC Bug: while formating output, the formatter ran off the end of the string while parsing a record pair starting at index " + index + " in the value " + string + "\n" + e.getMessage());
        }
        catch (ParseException e) {
            throw e;
        }
    }

    private static Node parseFunction(String string, int index) throws ParseException {
        int first = index;
        int last = index;
        try {
            Node node = new Node(string, first, 6);
            Node firstpair = null;
            Node lastpair = null;
            ++last;
            last = Parse.skipWhitespace(string, last);
            while (string.charAt(last) != ')') {
                Node pair = Parse.parseFunctionPair(string, last);
                if (firstpair == null) {
                    firstpair = pair;
                    lastpair = pair;
                } else {
                    lastpair.next(pair);
                    lastpair = pair;
                }
                last = pair.last() + 1;
                last = Parse.skipWhitespace(string, last);
                if (string.regionMatches(last, funSep, 0, funSep.length())) {
                    last += funSep.length();
                }
                last = Parse.skipWhitespace(string, last);
            }
            node.children(firstpair);
            node.last(last);
            return node;
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ParseException("TLC Bug: while formating output, the formatter ran off the end of the string while parsing a function starting at index " + index + " in the value " + string + "\n" + e.getMessage());
        }
        catch (ParseException e) {
            throw e;
        }
    }

    private static Node parseSubset(String string, int index) throws ParseException {
        int first = index;
        int last = index;
        try {
            Node node = new Node(string, first, 8);
            last += 6;
            last = Parse.skipWhitespace(string, last);
            Node elt = Parse.parse(string, last);
            node.children(elt);
            node.last(elt.last());
            return node;
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ParseException("TLC Bug: while formating output, the formatter ran off the end of the string while parsing a SUBSET starting at index " + index + " in the value " + string + "\n" + e.getMessage());
        }
        catch (ParseException e) {
            throw e;
        }
    }

    private static Node parseFunctionPair(String string, int index) throws ParseException {
        int first = index;
        int last = index;
        try {
            Node node = new Node(string, first, 7);
            Node domain = null;
            Node range = null;
            domain = Parse.parse(string, last);
            last = domain.last() + 1;
            last = Parse.skipWhitespace(string, last);
            if (!string.regionMatches(last, funDiv, 0, funDiv.length())) {
                throw new ParseException("TLC Bug: while formating output, the formatter couldn't find token :> while parsing a function arg/value pair starting at index " + index + " in value " + string);
            }
            last += funDiv.length();
            last = Parse.skipWhitespace(string, last);
            range = Parse.parse(string, last);
            domain.next(range);
            node.children(domain);
            node.last(range.last());
            return node;
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ParseException("TLC Bug: while formating output, the formatter ran off the end of the string while parsing a function pair starting at index " + index + " in the value " + string + "\n" + e.getMessage());
        }
        catch (ParseException e) {
            throw e;
        }
    }

    private static Node parseConstant(String string, int index) throws ParseException {
        try {
            Node node;
            int first;
            int last = first = Parse.skipWhitespace(string, index);
            if (string.charAt(first) == '\"') {
                while (string.charAt(++last) != '\"') {
                }
                return new Node(string, first, last, 1);
            }
            if (Character.isDigit(string.charAt(last)) && (node = Parse.parseInterval(string, index)) != null) {
                return node;
            }
            if (string.charAt(last) == '-') {
                ++last;
                while (Character.isDigit(string.charAt(last)) && ++last != string.length()) {
                }
                return new Node(string, first, --last, 1);
            }
            if (Character.isLetterOrDigit(string.charAt(last))) {
                while (Character.isLetterOrDigit(string.charAt(last)) && ++last != string.length()) {
                }
                return new Node(string, first, --last, 1);
            }
            throw new ParseException("TLC Bug: while formating output, the formatter discovered an illegal character while parsing a constant starting at index " + first + " in the value " + string);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ParseException("TLC Bug: while formating output, the formatter ran off the end of the string while parsing a constant starting at index " + index + " in the value " + string + "\n" + e.getMessage());
        }
        catch (ParseException e) {
            throw e;
        }
    }

    private static Node parseInterval(String string, int index) {
        try {
            int first;
            int last;
            if (!Character.isDigit(string.charAt(last))) {
                return null;
            }
            for (last = first = index; last < string.length() && Character.isDigit(string.charAt(last)); ++last) {
            }
            if (!string.startsWith(intDiv, last)) {
                return null;
            }
            ++last;
            if (!Character.isDigit(string.charAt(++last))) {
                return null;
            }
            while (Character.isDigit(string.charAt(last)) && ++last != string.length()) {
            }
            return new Node(string, first, --last, 1);
        }
        catch (StringIndexOutOfBoundsException e) {
            return null;
        }
    }

    public static int skipWhitespace(String string, int index) throws ParseException {
        try {
            int i = index;
            while (Character.isWhitespace(string.charAt(i))) {
                ++i;
            }
            return i;
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ParseException("TLC Bug: while formating output, the formatter ran off the end of the string while skipping whitespace starting at index " + index + " in the value " + string + "\n" + e.getMessage());
        }
    }
}

