/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.jsonrpc;

import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public final class CompletableFutures {
    private CompletableFutures() {
    }

    public static <R> CompletableFuture<R> computeAsync(Function<CancelChecker, R> code) {
        CompletableFuture<FutureCancelChecker> start2 = new CompletableFuture<FutureCancelChecker>();
        CompletionStage result = start2.thenApplyAsync(code);
        start2.complete(new FutureCancelChecker((CompletableFuture<?>)result));
        return result;
    }

    public static <R> CompletableFuture<R> computeAsync(Executor executor, Function<CancelChecker, R> code) {
        CompletableFuture<FutureCancelChecker> start2 = new CompletableFuture<FutureCancelChecker>();
        CompletionStage result = start2.thenApplyAsync(code, executor);
        start2.complete(new FutureCancelChecker((CompletableFuture<?>)result));
        return result;
    }

    public static class FutureCancelChecker
    implements CancelChecker {
        private final CompletableFuture<?> future;

        public FutureCancelChecker(CompletableFuture<?> future2) {
            this.future = future2;
        }

        @Override
        public void checkCanceled() {
            if (this.future.isCancelled()) {
                throw new CancellationException();
            }
        }

        @Override
        public boolean isCanceled() {
            return this.future.isCancelled();
        }
    }
}

