/*
 * Decompiled with CFR 0.152.
 */
package org.jline.reader.impl;

import org.jline.reader.LineReader;

public class ReaderUtils {
    private ReaderUtils() {
    }

    public static boolean isSet(LineReader reader2, LineReader.Option option) {
        return reader2 != null && reader2.isSet(option);
    }

    public static String getString(LineReader reader2, String name2, String def2) {
        Object v = reader2 != null ? reader2.getVariable(name2) : null;
        return v != null ? v.toString() : def2;
    }

    public static boolean getBoolean(LineReader reader2, String name2, boolean def2) {
        Object v;
        Object object = v = reader2 != null ? reader2.getVariable(name2) : null;
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        if (v != null) {
            String s = v.toString();
            return s.isEmpty() || s.equalsIgnoreCase("on") || s.equalsIgnoreCase("1") || s.equalsIgnoreCase("true");
        }
        return def2;
    }

    public static int getInt(LineReader reader2, String name2, int def2) {
        Object v;
        int nb = def2;
        Object object = v = reader2 != null ? reader2.getVariable(name2) : null;
        if (v instanceof Number) {
            return ((Number)v).intValue();
        }
        if (v != null) {
            nb = 0;
            try {
                nb = Integer.parseInt(v.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return nb;
    }

    public static long getLong(LineReader reader2, String name2, long def2) {
        Object v;
        long nb = def2;
        Object object = v = reader2 != null ? reader2.getVariable(name2) : null;
        if (v instanceof Number) {
            return ((Number)v).longValue();
        }
        if (v != null) {
            nb = 0L;
            try {
                nb = Long.parseLong(v.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return nb;
    }
}

