/*
 * Decompiled with CFR 0.152.
 */
package org.jline.utils;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.Objects;
import org.jline.utils.Log;

public final class ExecHelper {
    private ExecHelper() {
    }

    public static String exec(boolean redirectInput, String ... cmd) throws IOException {
        Objects.requireNonNull(cmd);
        try {
            Log.trace("Running: ", cmd);
            ProcessBuilder pb2 = new ProcessBuilder(cmd);
            if (redirectInput) {
                pb2.redirectInput(ProcessBuilder.Redirect.INHERIT);
            }
            Process p = pb2.start();
            String result = ExecHelper.waitAndCapture(p);
            Log.trace("Result: ", result);
            if (p.exitValue() != 0) {
                if (result.endsWith("\n")) {
                    result = result.substring(0, result.length() - 1);
                }
                throw new IOException("Error executing '" + String.join((CharSequence)" ", cmd) + "': " + result);
            }
            return result;
        }
        catch (InterruptedException e2) {
            throw (IOException)new InterruptedIOException("Command interrupted").initCause(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String waitAndCapture(Process p) throws IOException, InterruptedException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        InputStream in = null;
        InputStream err = null;
        OutputStream out = null;
        try {
            int c;
            in = p.getInputStream();
            while ((c = in.read()) != -1) {
                bout.write(c);
            }
            err = p.getErrorStream();
            while ((c = err.read()) != -1) {
                bout.write(c);
            }
            out = p.getOutputStream();
            p.waitFor();
        }
        catch (Throwable throwable) {
            ExecHelper.close(in, out, err);
            throw throwable;
        }
        ExecHelper.close(in, out, err);
        return bout.toString();
    }

    private static void close(Closeable ... closeables) {
        for (Closeable c : closeables) {
            if (c == null) continue;
            try {
                c.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

