/*
 * Decompiled with CFR 0.152.
 */
package pcal;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import pcal.AST;
import pcal.IntPair;
import pcal.PCalTLAGenerator;
import pcal.ParseAlgorithm;
import pcal.PcalCharReader;
import pcal.PcalDebug;
import pcal.PcalParams;
import pcal.PcalResourceFileReader;
import pcal.PcalTLAGen;
import pcal.TLAtoPCalMapping;
import pcal.ValidationCallBack;
import pcal.Validator;
import pcal.exception.FileToStringVectorException;
import pcal.exception.ParseAlgorithmException;
import pcal.exception.PcalResourceFileReaderException;
import pcal.exception.RemoveNameConflictsException;
import pcal.exception.StringVectorToFileException;
import pcal.exception.TLCTranslationException;
import pcal.exception.UnrecoverableException;
import util.ToolIO;

class trans {
    static final int STATUS_OK = 1;
    static final int STATUS_EXIT_WITHOUT_ERROR = 0;
    static final int STATUS_EXIT_WITH_ERRORS = -1;
    private static final String PCAL_TRANSLATION_COMMENT_LINE_PREFIX = "\\* BEGIN TRANSLATION";
    private static final String TLA_TRANSLATION_COMMENT_LINE_PREFIX = "\\* END TRANSLATION";

    trans() {
    }

    public static void main(String[] args) {
        trans.runMe(args);
    }

    public static int runMe(String[] args) {
        boolean writeCfg;
        if (ToolIO.getMode() == 0) {
            PcalDebug.reportInfo("pcal.trans Version 1.11 of 31 December 2020");
        }
        PcalParams.resetParams();
        int status = trans.parseAndProcessArguments(args);
        if (status != 1) {
            return trans.exitWithStatus(status);
        }
        List<String> inputVec = null;
        try {
            inputVec = trans.fileToStringVector(PcalParams.TLAInputFile + ".tla");
        }
        catch (FileToStringVectorException e2) {
            PcalDebug.reportError(e2);
            return trans.exitWithStatus(-1);
        }
        List<String> outputVec = trans.performTranslation(inputVec);
        if (outputVec == null) {
            return trans.exitWithStatus(-1);
        }
        try {
            File file2 = new File(PcalParams.TLAInputFile + ".old");
            if (file2.exists()) {
                file2.delete();
            }
            file2 = new File(PcalParams.TLAInputFile + ".tla");
            file2.renameTo(new File(PcalParams.TLAInputFile + ".old"));
        }
        catch (Exception e3) {
            PcalDebug.reportError("Could not rename input file " + PcalParams.TLAInputFile + ".tla" + " to " + PcalParams.TLAInputFile + ".old");
            return trans.exitWithStatus(-1);
        }
        try {
            trans.WriteStringVectorToFile(outputVec, PcalParams.TLAInputFile + ".tla");
        }
        catch (StringVectorToFileException e4) {
            PcalDebug.reportError(e4);
            return trans.exitWithStatus(-1);
        }
        PcalDebug.reportInfo("New file " + PcalParams.TLAInputFile + ".tla" + " written.");
        File cfgFile = new File(PcalParams.TLAInputFile + ".cfg");
        List<Object> cfg = null;
        boolean bl = writeCfg = !PcalParams.Nocfg;
        if (writeCfg && cfgFile.exists()) {
            if (cfgFile.canRead()) {
                try {
                    cfg = trans.fileToStringVector(PcalParams.TLAInputFile + ".cfg");
                }
                catch (FileToStringVectorException e5) {
                    PcalDebug.reportError(e5);
                    return trans.exitWithStatus(-1);
                }
            } else {
                writeCfg = false;
                PcalDebug.reportInfo("File " + PcalParams.TLAInputFile + ".cfg is read only, new version not written.");
            }
        } else {
            cfg = new ArrayList<String>();
            cfg.add(PcalParams.CfgFileDelimiter);
        }
        if (writeCfg) {
            int j = 0;
            boolean done = false;
            while (!done && cfg.size() > j) {
                if (((String)cfg.get(j)).indexOf(PcalParams.CfgFileDelimiter) == -1) {
                    ++j;
                    continue;
                }
                done = true;
            }
            if (done) {
                while (j > 0) {
                    cfg.remove(0);
                    --j;
                }
            } else {
                cfg.add(0, PcalParams.CfgFileDelimiter);
            }
            if (PcalParams.tlcTranslation() || ParseAlgorithm.hasDefaultInitialization) {
                cfg.add(0, "CONSTANT defaultInitValue = defaultInitValue");
            }
            if (PcalParams.CheckTermination) {
                cfg.add(0, "PROPERTY Termination");
            }
            boolean hasSpec = false;
            for (String string2 : cfg) {
                if (string2.indexOf("SPECIFICATION") == -1 || string2.indexOf("\\*") != -1 && string2.indexOf("\\*") <= string2.indexOf("SPECIFICATION")) continue;
                hasSpec = true;
                break;
            }
            if (hasSpec) {
                PcalDebug.reportInfo("File " + PcalParams.TLAInputFile + ".cfg already contains " + "SPECIFICATION" + " statement,\n   so new one not written.");
            } else {
                cfg.add(0, "SPECIFICATION Spec");
            }
            try {
                trans.WriteStringVectorToFile(cfg, PcalParams.TLAInputFile + ".cfg");
            }
            catch (StringVectorToFileException e6) {
                PcalDebug.reportError(e6);
                return trans.exitWithStatus(-1);
            }
            PcalDebug.reportInfo("New file " + PcalParams.TLAInputFile + ".cfg" + " written.");
        }
        return trans.exitWithStatus(0);
    }

    public static List<String> performTranslation(List<String> specificationText) {
        return trans.performTranslation(specificationText, new ValidationCallBack.Noop());
    }

    public static List<String> performTranslation(List<String> specificationText, ValidationCallBack cb) {
        TLAtoPCalMapping mapping;
        PcalParams.tlaPcalMapping = mapping = new TLAtoPCalMapping();
        Vector<String> untabInputVec = trans.removeTabs(specificationText);
        IntPair searchLoc = new IntPair(0, 0);
        boolean notDone = true;
        while (notDone) {
            try {
                ParseAlgorithm.FindToken("PlusCal", untabInputVec, searchLoc, "");
                String line = ParseAlgorithm.GotoNextNonSpace(untabInputVec, searchLoc);
                String restOfLine = line.substring(searchLoc.two);
                if (!restOfLine.startsWith("options") || ParseAlgorithm.NextNonIdChar(restOfLine, 0) != 7) continue;
                PcalParams.optionsInFile = true;
                ParseAlgorithm.ProcessOptions(untabInputVec, searchLoc);
                notDone = false;
            }
            catch (ParseAlgorithmException e2) {
                notDone = false;
            }
        }
        int translationLine = 0;
        int algLine = 0;
        int algCol = -1;
        ArrayList<String> output = new ArrayList<String>(specificationText);
        translationLine = trans.findTokenPair(untabInputVec, 0, "BEGIN", "TRANSLATION");
        int endTranslationLine = -1;
        if (translationLine != -1) {
            endTranslationLine = trans.findTokenPair(untabInputVec, translationLine + 1, "END", "TRANSLATION");
            if (endTranslationLine == -1) {
                PcalDebug.reportError("No line containing `END TRANSLATION");
                return null;
            }
            for (int etl = endTranslationLine - 1; translationLine < etl; --etl) {
                output.remove(etl);
                untabInputVec.remove(etl);
            }
        }
        boolean foundBegin = false;
        boolean foundFairBegin = false;
        while (algLine < untabInputVec.size() && !foundBegin) {
            String line = untabInputVec.elementAt(algLine);
            algCol = line.indexOf("--algorithm");
            if (algCol != -1) {
                algCol += "--algorithm".length();
                foundBegin = true;
                continue;
            }
            algCol = line.indexOf("--fair");
            if (algCol != -1) {
                algCol += "--fair".length();
                foundBegin = true;
                foundFairBegin = true;
                continue;
            }
            ++algLine;
        }
        if (!foundBegin) {
            PcalDebug.reportError("Beginning of algorithm string --algorithm not found.");
            return null;
        }
        mapping.algColumn = algCol;
        mapping.algLine = algLine;
        if (translationLine == -1) {
            int depth = 1;
            int ecLine = algLine;
            int ecCol = algCol;
            boolean notFound = true;
            while (notFound && ecLine < untabInputVec.size()) {
                char[] line = untabInputVec.elementAt(ecLine).toCharArray();
                while (notFound && ecCol < line.length - 1) {
                    char ch = line[ecCol];
                    char ch2 = line[ecCol + 1];
                    if (ch == '(' && ch2 == '*') {
                        ++depth;
                        ecCol += 2;
                        continue;
                    }
                    if (ch == '*' && ch2 == ')') {
                        ecCol += 2;
                        if (--depth != 0) continue;
                        notFound = false;
                        continue;
                    }
                    ++ecCol;
                }
                if (!notFound) continue;
                ++ecLine;
                ecCol = 0;
            }
            if (notFound) {
                PcalDebug.reportError("Algorithm not in properly terminated comment");
                return null;
            }
            String endStuff = untabInputVec.elementAt(ecLine).substring(ecCol).trim();
            if (!endStuff.equals("") && !endStuff.startsWith("\\*")) {
                PcalDebug.reportError("Text on same line following `*)' that ends the \n   comment containing the algorithm.");
                return null;
            }
            output.add(ecLine + 1, "\\* BEGIN TRANSLATION " + String.format("(chksum(pcal) = \"%s\" /\\ chksum(tla) = \"%s\")", "ffffffff", "ffffffff"));
            untabInputVec.insertElementAt(PCAL_TRANSLATION_COMMENT_LINE_PREFIX, ecLine + 1);
            output.add(ecLine + 2, "\\* END TRANSLATION ");
            untabInputVec.insertElementAt(TLA_TRANSLATION_COMMENT_LINE_PREFIX, ecLine + 2);
            translationLine = ecLine + 1;
        } else {
            Matcher m = Validator.CHECKSUM_PATTERN.matcher(output.get(translationLine));
            if (m.find() && m.group("tlachecksum") != null) {
                String checksumTLATranslation = Validator.checksum(new Vector<String>(specificationText.subList(translationLine + 1, endTranslationLine)));
                if (!m.group("tlachecksum").equals(checksumTLATranslation) && cb.shouldCancel()) {
                    return null;
                }
            }
        }
        mapping.tlaStartLine = translationLine + 1;
        try {
            ParseAlgorithm.uncomment(untabInputVec, algLine, algCol);
        }
        catch (ParseAlgorithmException e3) {
            PcalDebug.reportError(e3);
            return null;
        }
        PcalCharReader reader2 = new PcalCharReader(untabInputVec, algLine, algCol, output.size(), 0);
        AST ast = null;
        try {
            ast = ParseAlgorithm.getAlgorithm(reader2, foundFairBegin);
        }
        catch (ParseAlgorithmException e4) {
            PcalDebug.reportError(e4);
            return null;
        }
        PcalDebug.reportInfo("Parsing completed.");
        if (PcalParams.WriteASTFlag) {
            trans.WriteAST(ast);
            return null;
        }
        PCalTLAGenerator pcalTLAGenerator = new PCalTLAGenerator(ast);
        try {
            pcalTLAGenerator.removeNameConflicts();
        }
        catch (RemoveNameConflictsException e1) {
            PcalDebug.reportError(e1);
            return null;
        }
        Vector<String> translation = null;
        if (PcalParams.tlcTranslation()) {
            try {
                translation = trans.TLCTranslate(ast);
            }
            catch (TLCTranslationException e5) {
                PcalDebug.reportError(e5);
                return null;
            }
        }
        try {
            translation = pcalTLAGenerator.translate();
        }
        catch (RemoveNameConflictsException e6) {
            PcalDebug.reportError(e6);
            return null;
        }
        Matcher m = Validator.CHECKSUM_PATTERN.matcher(output.get(mapping.tlaStartLine - 1));
        ValidationCallBack.Generate g = null;
        if (m.find()) {
            if (m.group("tlachecksum") != null) {
                output.set(mapping.tlaStartLine - 1, new StringBuilder(output.get(mapping.tlaStartLine - 1)).replace(m.start("tlachecksum"), m.end("tlachecksum"), Validator.checksum(translation)).toString());
            }
            if (m.group("pcalchecksum") != null) {
                output.set(mapping.tlaStartLine - 1, new StringBuilder(output.get(mapping.tlaStartLine - 1)).replace(m.start("pcalchecksum"), m.end("pcalchecksum"), Validator.checksum(ast.toString())).toString());
            }
        } else {
            g = cb.shouldGenerate();
            if (g != ValidationCallBack.Generate.NOT_NOW) {
                if (g == ValidationCallBack.Generate.DO_IT) {
                    output.set(mapping.tlaStartLine - 1, output.get(mapping.tlaStartLine - 1) + " " + String.format("(chksum(pcal) = \"%s\" /\\ chksum(tla) = \"%s\")", Validator.checksum(ast.toString()), Validator.checksum(translation)));
                } else {
                    output.set(mapping.tlaStartLine - 1, output.get(mapping.tlaStartLine - 1) + " " + "(chksum(pcal) \\in STRING /\\ chksum(tla) \\in STRING)");
                }
            }
        }
        for (int i = 0; i < translation.size(); ++i) {
            output.add(i + translationLine + 1, translation.elementAt(i));
        }
        PcalDebug.reportInfo("Translation completed.");
        return output;
    }

    private static int exitWithStatus(int status) {
        if (ToolIO.getMode() == 0) {
            System.exit(status);
        }
        return status;
    }

    private static boolean WriteAST(AST ast) {
        Vector<String> astFile = new Vector<String>();
        astFile.addElement("------ MODULE AST -------");
        astFile.addElement("EXTENDS TLC");
        astFile.addElement("fairness == \"" + PcalParams.FairnessOption + "\"");
        astFile.addElement(" ");
        astFile.addElement("ast == ");
        astFile.addElement(ast.toString());
        astFile.addElement("==========================");
        try {
            trans.WriteStringVectorToFile(astFile, "AST.tla");
        }
        catch (StringVectorToFileException e2) {
            PcalDebug.reportError(e2);
            return false;
        }
        PcalDebug.reportInfo("Wrote file AST.tla.");
        return true;
    }

    private static Vector<String> TLCTranslate(AST ast) throws TLCTranslationException {
        String javaInvocation;
        trans.WriteAST(ast);
        if (PcalParams.SpecOption || PcalParams.Spec2Option) {
            try {
                Vector<String> parseFile = PcalResourceFileReader.ResourceFileToStringVector(PcalParams.SpecFile + ".tla");
                trans.WriteStringVectorToFile(parseFile, PcalParams.SpecFile + ".tla");
                parseFile = PcalResourceFileReader.ResourceFileToStringVector(PcalParams.SpecFile + ".cfg");
                trans.WriteStringVectorToFile(parseFile, PcalParams.SpecFile + ".cfg");
                PcalDebug.reportInfo("Wrote files " + PcalParams.SpecFile + ".tla" + " and " + PcalParams.SpecFile + ".cfg" + ".");
            }
            catch (UnrecoverableException e2) {
                throw new TLCTranslationException(e2.getMessage());
            }
        }
        if (PcalParams.SpecOption || PcalParams.MyspecOption) {
            PcalDebug.reportInfo("Running TLC2.");
            javaInvocation = "java -Xss1m tlc2.TLC ";
        } else {
            PcalDebug.reportInfo("Running TLC2.");
            javaInvocation = "java -Xss1m tlc2.TLC ";
        }
        String tlcOut = "      ";
        Runtime rt = Runtime.getRuntime();
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(rt.exec(javaInvocation + PcalParams.SpecFile).getInputStream()));
            while (tlcOut.indexOf("<<") == -1) {
                tlcOut = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (Exception e3) {
            throw new TLCTranslationException("Error reading output of TLC");
        }
        if (tlcOut.indexOf("@Error@") != -1) {
            throw new TLCTranslationException("TLC's translation of the parsed algorithm failed with\n  Error: " + tlcOut.substring(tlcOut.indexOf("@Error@") + 7, tlcOut.indexOf("@EndError@")));
        }
        tlcOut = tlcOut.substring(2, tlcOut.lastIndexOf(">>")) + "  ";
        PcalDebug.reportInfo("Read TLC output.");
        int i = 0;
        String transl = "";
        while (i < tlcOut.length()) {
            if (tlcOut.charAt(i) == '\"') {
                if (tlcOut.charAt(++i) == '\\' && tlcOut.charAt(i + 1) == '\"') {
                    if (tlcOut.charAt(i + 2) != '\"') {
                        throw new TLCTranslationException("I'm confused");
                    }
                    i += 3;
                    while (tlcOut.charAt(i) != '\"') {
                        ++i;
                    }
                    ++i;
                    transl = transl + "\"";
                    while (tlcOut.charAt(i) != '\"') {
                        if (tlcOut.charAt(i) == '\\') {
                            transl = transl + tlcOut.substring(i, i + 2);
                            i += 2;
                            continue;
                        }
                        transl = transl + tlcOut.substring(i, i + 1);
                        ++i;
                    }
                    i += 8;
                    transl = transl + "\"";
                    continue;
                }
                while (tlcOut.charAt(i) != '\"') {
                    if (tlcOut.charAt(i) == '\\' && tlcOut.charAt(i + 1) == '\\') {
                        ++i;
                    }
                    transl = transl + tlcOut.substring(i, i + 1);
                    ++i;
                }
                ++i;
                continue;
            }
            if (tlcOut.charAt(i) == ',') {
                ++i;
                continue;
            }
            if (tlcOut.charAt(i) != ' ') {
                throw new TLCTranslationException("Expected space but found `" + tlcOut.charAt(i) + "'");
            }
            transl = transl + tlcOut.substring(i, i + 1);
            ++i;
        }
        transl = trans.WrapString(transl, 78);
        Vector<String> result = new Vector<String>();
        result.addElement(transl);
        return result;
    }

    private static void WriteStringVectorToFile(List<String> inputVec, String fileName) throws StringVectorToFileException {
        try (BufferedWriter fileW = new BufferedWriter(new FileWriter(fileName));){
            for (String line : inputVec) {
                fileW.write(line);
                fileW.newLine();
            }
        }
        catch (Exception e2) {
            throw new StringVectorToFileException("Could not write file " + fileName);
        }
    }

    private static List<String> fileToStringVector(String fileName) throws FileToStringVectorException {
        ArrayList<String> inputVec = new ArrayList<String>(100);
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(fileName)));){
            String nextLine = bufferedReader.readLine();
            while (nextLine != null) {
                inputVec.add(nextLine);
                nextLine = bufferedReader.readLine();
            }
        }
        catch (FileNotFoundException e2) {
            throw new FileToStringVectorException("Input file " + fileName + " not found.");
        }
        catch (IOException e3) {
            throw new FileToStringVectorException("Error reading file " + fileName + ".");
        }
        return inputVec;
    }

    static int parseAndProcessArguments(String[] args) {
        int nextArg;
        boolean inFile = PcalParams.optionsInFile;
        boolean notInFile = !inFile;
        boolean firstFairness = inFile;
        boolean explicitNof = false;
        int maxArg = args.length - 1;
        if (maxArg < 0) {
            return trans.CommandLineError("No arguments specified");
        }
        if (notInFile && args[maxArg].length() != 0 && args[maxArg].charAt(0) == '-') {
            if (trans.OutputHelpMessage()) {
                return 0;
            }
            return -1;
        }
        for (nextArg = 0; nextArg < maxArg; ++nextArg) {
            String option = args[nextArg];
            if (notInFile && option.equals("-help")) {
                if (trans.OutputHelpMessage()) {
                    return 0;
                }
                return -1;
            }
            if (notInFile && option.equals("-writeAST")) {
                PcalParams.WriteASTFlag = true;
                if (!trans.CheckForConflictingSpecOptions()) continue;
                return -1;
            }
            if (option.equals("-spec") || inFile && option.equals("spec")) {
                PcalParams.SpecOption = true;
                if (trans.CheckForConflictingSpecOptions()) {
                    return -1;
                }
                if (++nextArg == maxArg) {
                    return trans.CommandLineError("Specification name must follow `-spec' option");
                }
                PcalParams.SpecFile = args[nextArg];
                continue;
            }
            if (option.equals("-myspec") || inFile && option.equals("myspec")) {
                PcalParams.MyspecOption = true;
                if (trans.CheckForConflictingSpecOptions()) {
                    return -1;
                }
                if (++nextArg == maxArg) {
                    return trans.CommandLineError("Specification name must follow `-myspec' option");
                }
                PcalParams.SpecFile = args[nextArg];
                continue;
            }
            if (notInFile && option.equals("-spec2")) {
                PcalParams.Spec2Option = true;
                if (trans.CheckForConflictingSpecOptions()) {
                    return -1;
                }
                if (++nextArg == maxArg) {
                    return trans.CommandLineError("Specification name must follow `-spec' option");
                }
                PcalParams.SpecFile = args[nextArg];
                continue;
            }
            if (notInFile && option.equals("-myspec2")) {
                PcalParams.Myspec2Option = true;
                if (trans.CheckForConflictingSpecOptions()) {
                    return -1;
                }
                if (++nextArg == maxArg) {
                    return trans.CommandLineError("Specification name must follow `-myspec' option");
                }
                PcalParams.SpecFile = args[nextArg];
                continue;
            }
            if (notInFile && option.equals("-debug")) {
                PcalParams.Debug = true;
                continue;
            }
            if (notInFile && option.equals("-unixEOL")) {
                System.setProperty("line.separator", "\n");
                continue;
            }
            if (option.equals("-termination") || inFile && option.equals("termination")) {
                PcalParams.CheckTermination = true;
                continue;
            }
            if (option.equals("-nocfg")) {
                PcalParams.Nocfg = true;
                continue;
            }
            if (option.equals("-noDoneDisjunct") || inFile && option.equals("noDoneDisjunct")) {
                PcalParams.NoDoneDisjunct = true;
                continue;
            }
            if (option.equals("-wf") || inFile && option.equals("wf")) {
                if (firstFairness) {
                    PcalParams.FairnessOption = "";
                    firstFairness = false;
                }
                if (!PcalParams.FairnessOption.equals("")) {
                    return trans.CommandLineError("Can only have one of -wf, -sf, -wfNext, and -nof options");
                }
                PcalParams.FairnessOption = "wf";
                continue;
            }
            if (option.equals("-sf") || inFile && option.equals("sf")) {
                if (firstFairness) {
                    PcalParams.FairnessOption = "";
                    firstFairness = false;
                }
                if (!PcalParams.FairnessOption.equals("")) {
                    return trans.CommandLineError("Can only have one of -wf, -sf, -wfNext, and -nof options");
                }
                PcalParams.FairnessOption = "sf";
                continue;
            }
            if (option.equals("-wfNext") || inFile && option.equals("wfNext")) {
                if (firstFairness) {
                    PcalParams.FairnessOption = "";
                    firstFairness = false;
                }
                if (!PcalParams.FairnessOption.equals("")) {
                    return trans.CommandLineError("Can only have one of -wf, -sf, -wfNext, and -nof options");
                }
                PcalParams.FairnessOption = "wfNext";
                continue;
            }
            if (option.equals("-nof") || inFile && option.equals("nof")) {
                if (firstFairness) {
                    PcalParams.FairnessOption = "";
                    firstFairness = false;
                }
                if (!PcalParams.FairnessOption.equals("")) {
                    return trans.CommandLineError("Can only have one of -wf, -sf, -wfNext, and -nof options");
                }
                PcalParams.FairnessOption = "nof";
                explicitNof = true;
                continue;
            }
            if (option.equals("-label") || inFile && option.equals("label")) {
                PcalParams.LabelFlag = true;
                continue;
            }
            if (notInFile && option.equals("-reportLabels")) {
                PcalParams.ReportLabelsFlag = true;
                PcalParams.LabelFlag = true;
                continue;
            }
            if (option.equals("-labelRoot") || inFile && option.equals("labelRoot")) {
                if (++nextArg == maxArg) {
                    return trans.CommandLineError("Label root must follow `-labelRoot' option");
                }
                PcalParams.LabelRoot = args[nextArg];
                continue;
            }
            if (option.equals("-version") || inFile && option.equals("version")) {
                if (++nextArg == maxArg) {
                    return trans.CommandLineError("Version number must follow `-version' option");
                }
                if (PcalParams.ProcessVersion(args[nextArg])) continue;
                return trans.CommandLineError("Bad version number");
            }
            if (option.equals("-lineWidth")) {
                ++nextArg;
                try {
                    if (nextArg == maxArg) {
                        throw new NumberFormatException();
                    }
                    int a = new Integer(args[nextArg]);
                    if (a < 60) {
                        throw new NumberFormatException();
                    }
                    PcalTLAGen.wrapColumn = a;
                    PcalTLAGen.ssWrapColumn = a - 33;
                    continue;
                }
                catch (Exception e2) {
                    return trans.CommandLineError("Integer value at least 60 must follow `-lineWidth' option");
                }
            }
            if (notInFile) {
                return trans.CommandLineError("Unknown command-line option: " + option);
            }
            return trans.CommandLineError("Unknown or illegal option in options statement: " + option);
        }
        if (nextArg > maxArg) {
            return trans.CommandLineError("No input file specified");
        }
        if (PcalParams.FairnessOption.equals("-nof")) {
            PcalParams.FairnessOption = "";
        }
        if (PcalParams.CheckTermination && PcalParams.FairnessOption.equals("") && !explicitNof) {
            PcalParams.FairnessOption = "wf";
        }
        if (inFile) {
            return 1;
        }
        File file2 = new File(args[maxArg]);
        boolean hasExtension = false;
        if (file2.getName().lastIndexOf(".") == -1) {
            PcalParams.TLAInputFile = file2.getPath();
        } else if (file2.getName().toLowerCase().endsWith(".tla")) {
            hasExtension = true;
        } else {
            return trans.CommandLineError("Input file has extension other than tla");
        }
        if (hasExtension) {
            PcalParams.TLAInputFile = file2.getPath().substring(0, file2.getPath().lastIndexOf("."));
            if (!file2.exists()) {
                return trans.CommandLineError("Input file " + file2.getPath() + " does not exist.");
            }
        } else {
            file2 = new File(PcalParams.TLAInputFile + ".tla");
            if (!file2.exists()) {
                return trans.CommandLineError("Input file " + PcalParams.TLAInputFile + ".pcal and " + file2.getPath() + ".tla not found");
            }
        }
        return 1;
    }

    private static boolean OutputHelpMessage() {
        Vector<String> helpVec = null;
        try {
            helpVec = PcalResourceFileReader.ResourceFileToStringVector("help.txt");
        }
        catch (PcalResourceFileReaderException e2) {
            PcalDebug.reportError(e2);
            return false;
        }
        for (int i = 0; i < helpVec.size(); ++i) {
            ToolIO.out.println(helpVec.elementAt(i));
        }
        return true;
    }

    private static boolean CheckForConflictingSpecOptions() {
        if ((PcalParams.SpecOption ? 1 : 0) + (PcalParams.MyspecOption ? 1 : 0) + (PcalParams.Spec2Option ? 1 : 0) + (PcalParams.Myspec2Option ? 1 : 0) + (PcalParams.WriteASTFlag ? 1 : 0) > 1) {
            trans.CommandLineError("\nCan have at most one of the options -spec, -myspec, -spec2, -myspec2, writeAST");
            return true;
        }
        return false;
    }

    private static int CommandLineError(String msg) {
        PcalDebug.reportError("Command-line error: " + msg + ".");
        return -1;
    }

    static int findTokenPair(Vector<String> vec2, int lineNum, String tok1, String tok2) {
        for (int i = lineNum; i < vec2.size(); ++i) {
            int nextcol;
            String line = vec2.elementAt(i);
            int col = line.indexOf(tok1);
            if (col == -1) continue;
            for (nextcol = col + tok1.length(); nextcol < line.length() && line.charAt(nextcol) == ' '; ++nextcol) {
            }
            if (nextcol >= line.length() || nextcol != line.indexOf(tok2)) continue;
            return i;
        }
        return -1;
    }

    public static Vector<String> removeTabs(List<String> input) {
        Vector<String> newVec = new Vector<String>();
        for (String oldLine : input) {
            String newLine = "";
            for (int next2 = 0; next2 < oldLine.length(); ++next2) {
                if (oldLine.charAt(next2) == '\t') {
                    for (int toAdd = 8 - newLine.length() % 8; toAdd > 0; --toAdd) {
                        newLine = newLine + " ";
                    }
                    continue;
                }
                newLine = newLine + oldLine.substring(next2, next2 + 1);
            }
            newLine = newLine + " ";
            newVec.add(newLine);
        }
        return newVec;
    }

    private static int NextSpace(String s, int cur) {
        int i;
        boolean inString = false;
        for (i = cur; i < s.length() && (s.charAt(i) != ' ' || inString); ++i) {
            if (s.charAt(i) != '\"' || i != 0 && s.charAt(i - 1) == '\\') continue;
            inString = !inString;
        }
        if (i == s.length()) {
            return i - 1;
        }
        return i;
    }

    private static String WrapString(String inString, int col) {
        int i = 0;
        int ccol = 1;
        StringBuffer sb = new StringBuffer();
        while (i < inString.length()) {
            if (inString.charAt(i) == ' ') {
                sb.append(' ');
                ++i;
                ++ccol;
                continue;
            }
            int j = trans.NextSpace(inString, i);
            if (ccol + (j - i + 1) > col) {
                sb.append('\n');
                ccol = 1;
            }
            while (i <= j) {
                sb.append(inString.charAt(i));
                ++i;
                ++ccol;
            }
        }
        return sb.toString();
    }
}

